package cn.qg.holmes.entity.monitor;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 监控数据源表
 * @author libo
 */
@Data
@TableName(value = "sql_monitor_data_source")
public class SqlMonitorDataSource {

    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 数据源名称
     */
    @TableField(value = "`name`")
    private String name;

    /**
     * 数据源host
     */
    @TableField(value = "`host`")
    private String host;

    /**
     * 数据源端口
     */
    @TableField(value = "`port`")
    private String port;

    /**
     * 数据源用户名
     */
    @TableField(value = "`username`")
    private String username;

    /**
     * 数据源密码
     */
    @TableField(value = "`password`")
    private String password;

    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "`update_time`")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
