package cn.qg.holmes.service.k8s;

import com.alibaba.fastjson.JSON;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.tcr.v20190924.TcrClient;
import com.tencentcloudapi.tcr.v20190924.models.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 镜像仓库相关服务
 * @author libo 2021
 */
@Slf4j
@Component
public class ImageService {

    private TcrClient tcrClient;

    public ImageService() {
        try {
            Credential credential = new Credential("AKID4rY7wwNphsUcaFsy1pRtKhQvDj4CA3Ac", "YBduRnjgVRGzmagZJbss3Vo58wWCyhgc");

            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setSignMethod("HmacSHA256");

            tcrClient = new TcrClient(credential, "ap-beijing", clientProfile);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 根据服务名获取镜像列表
     * @param repoName 服务名
     * @return
     */
    public Map<String, Object> getImageListByService(String repoName) {
        try {
            DescribeImagePersonalRequest request = new DescribeImagePersonalRequest();
            request.setRepoName(repoName);
            DescribeImagePersonalResponse response = tcrClient.DescribeImagePersonal(request);
            return JSON.parseObject(DescribeImagePersonalResponse.toJsonString(response.getData()), Map.class);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取腾讯镜像仓库的镜像
     * @param namespace qa-base, qa-java, qa-ui 等等
     * @return
     */
    public List<RepoInfo> getRepoInfoList(String namespace) {
        try {
            DescribeRepositoryFilterPersonalRequest request = new DescribeRepositoryFilterPersonalRequest();
            request.setNamespace(namespace);
            request.setPublic(-1L);
            request.setOffset(0L);
            request.setLimit(100L);
            request.setRepoName("");
            DescribeRepositoryFilterPersonalResponse response = tcrClient.DescribeRepositoryFilterPersonal(request);
            Long TotalCount = response.getData().getTotalCount();
            List<RepoInfo> repoInfoList = new ArrayList<>(Arrays.asList(response.getData().getRepoInfo()));
            int num = Math.toIntExact(TotalCount / 100);
            if ((TotalCount % 100) > 0) {
                num = num + 1;
            }
            for (int i=1; i < num; i++) {
                request.setOffset(100L * i);
                response = tcrClient.DescribeRepositoryFilterPersonal(request);
                repoInfoList.addAll(Arrays.asList(response.getData().getRepoInfo()));
            }
            return repoInfoList;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ImageService imageService = new ImageService();
        System.out.println(JSON.toJSONString(imageService.getRepoInfoList("qa-test")));
    }

}
