package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.*;
import cn.qg.holmes.service.auth.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

@CrossOrigin
@RestController
@RequestMapping("/role")
public class RoleController {

    @Autowired
    RoleService roleService;

    @Autowired
    UserRoleService userRoleService;

    @Autowired
    UserService userService;

    @Autowired
    RolePermissionService rolePermissionService;

    @Autowired
    PermissionService permissionService;

    /**
     * 获取角色列表
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getRoleList(@RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        IPage<Role> roleIPage = new Page<>(pageNum, pageSize);
        IPage page = roleService.page(roleIPage);
        Map<String, Object> map = new HashMap<>();
        List<Map<String, Object>> roleTotalInfoList = new ArrayList<>();
        List<Role> roleList = page.getRecords();
        for (Role role: roleList) {
            Map<String, Object> roleInfoMap = new HashMap<>();
            QueryWrapper<UserRole> userRoleQueryWrapper = new QueryWrapper<>();
            QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
            Integer roleId = role.getId();
            userRoleQueryWrapper.eq("role_id", roleId);
            rolePermissionQueryWrapper.eq("role_id", roleId);
            List<UserRole> userRoleList = userRoleService.list(userRoleQueryWrapper);
            List<RolePermission> rolePermissionList = rolePermissionService.list(rolePermissionQueryWrapper);
            List<String> usernameList = new ArrayList<>();
            List<Integer> permissionIdList = new ArrayList<>();
            for (UserRole userRole: userRoleList) {
                User user = userService.getById(userRole.getUserId());
                usernameList.add(user.getUsername());
            }
            for (RolePermission rolePermission: rolePermissionList) {
                Permission permission = permissionService.getById(rolePermission.getPermissionId());
                permissionIdList.add(permission.getId());
            }
            userRoleQueryWrapper.clear();
            rolePermissionQueryWrapper.clear();
            roleInfoMap.put("roleId", role.getId());
            roleInfoMap.put("roleName", role.getRoleName());
            roleInfoMap.put("usernameList", usernameList);
            roleInfoMap.put("permissionIdList", permissionIdList);
            roleTotalInfoList.add(roleInfoMap);
        }
        map.put("total", page.getTotal());
        map.put("list", roleTotalInfoList);
        return JsonResult.buildSuccessResult(map);
    }

}
