package cn.qg.holmes.controller.login;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.mapper.auth.UserMapper;
import cn.qg.holmes.service.ldap.LoginService;
import cn.qg.holmes.service.ldap.TokenService;
import cn.qg.holmes.service.ldap.UserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import sun.security.provider.MD5;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
public class LoginController {

    @Autowired
    LoginService loginService;

    @Autowired
    TokenService tokenService;

    @Autowired
    UserService userService;

    @PostMapping("/login")
    public JsonResult login(String username, String password) {
        boolean loginResult = loginService.login(username, password);
        if (!loginResult) {
            return JsonResult.buildErrorStateResult("用户名或密码错误", false);
        }
        User user = userService.getUserByUsername(username);
        // 用户不存在，则创建新用户
        if (user == null) {
            user.setUsername(username);
            user.setPassword(DigestUtils.md5DigestAsHex(password.getBytes(StandardCharsets.UTF_8)));
            userService.save(user);
        }
        String token = tokenService.generateToken(user.getId());
        Map<String, Object> map = new HashMap<>();
        map.put("token", token);
        return JsonResult.buildSuccessResult(map);
    }
}
