package cn.qg.holmes.service.ldap.impl;

import cn.qg.holmes.entity.auth.SessionUserInfo;
import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.mapper.auth.UserMapper;
import cn.qg.holmes.service.ldap.TokenService;
import cn.qg.holmes.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.naming.ContextNotEmptyException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Slf4j
@Service
public class TokenServiceImpl implements TokenService {

    private final String TOKEN_PREFIX = "user:token:";

    @Autowired
    RedisUtils redisUtils;

    @Autowired
    UserMapper userMapper;

    /**
     * 生成token并存放到redis
     * @param userId 用户id
     * @return
     */
    @Override
    public String generateToken(Integer userId) {
        String token = UUID.randomUUID().toString().replace("-", "").substring(0, 20);
        Map<String, Object> map = new HashMap<>();
        User user = userMapper.selectById(userId);
        map.put("userId", userId);
        map.put("username", user.getUsername());
        //设置用户信息缓存
        redisUtils.set(TOKEN_PREFIX + token, map);
        return token;
    }

    /**
     * 根据token从redis获取用户信息
     * @param token 用户token
     * @return
     */
    @Override
    public SessionUserInfo getUserInfoFromCache(String token) {
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        SessionUserInfo sessionUserInfo = (SessionUserInfo) redisUtils.get(token);
        return sessionUserInfo;
    }
}
