package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.SceneTestcaseReport;
import cn.qg.holmes.mapper.auto.SceneTestcaseReportMapper;
import cn.qg.holmes.service.auto.SceneTestcaseReportService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class SceneTestcaseReportServiceImpl extends ServiceImpl<SceneTestcaseReportMapper, SceneTestcaseReport> implements SceneTestcaseReportService {

    @Autowired
    SceneTestcaseReportMapper sceneTestcaseReportMapper;

    @Override
    public Map<String, Object> getSceneTestcaseReportListByNamespace(String namespace, Integer pageNum, Integer pageSize) {
        QueryWrapper<SceneTestcaseReport> queryWrapper = new QueryWrapper<>();
        if (namespace != null && !namespace.isEmpty()) {
            queryWrapper.eq("namespace", namespace);
        }
        queryWrapper.orderByDesc("id");

        Page<SceneTestcaseReport> page = new Page<>(pageNum, pageSize);
        IPage<SceneTestcaseReport> iPage = sceneTestcaseReportMapper.selectPage(page, queryWrapper);

        Map<String, Object> map = new HashMap<>();
        map.put("total", iPage.getTotal());
        map.put("list", iPage.getRecords());
        return map;
    }
}
