package cn.qg.holmes.controller.mock;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.mock.Mock;
import cn.qg.holmes.entity.mock.MockModule;
import cn.qg.holmes.service.mock.MockModuleService;
import cn.qg.holmes.service.mock.MockService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@CrossOrigin
@RestController
public class MockController {

    @Autowired
    MockService mockService;

    @Autowired
    MockModuleService mockModuleService;

    @RequestMapping(value = "/mock/**", method = { RequestMethod.GET, RequestMethod.POST})
    public void mockMethod() {}

    @PostMapping("/add/mock")
    public JsonResult addMock(@RequestBody Mock mock) {
        return JsonResult.buildSuccessResult(mockService.save(mock));
    }

    @GetMapping("/list/mock")
    public JsonResult getMockList(Integer pageNum, Integer pageSize, Integer module) {
        IPage<Mock> page = new Page<>(pageNum, pageSize);
        IPage<Mock> pageEntity;
        if (module != null) {
            QueryWrapper<Mock> queryWrapper = new QueryWrapper();
            queryWrapper.eq("module", module);
            pageEntity = mockService.page(page, queryWrapper);
        } else {
            pageEntity = mockService.page(page);
        }
        Map<String, Object> map = new HashMap<>();
        map.put("list", pageEntity.getRecords());
        map.put("total", pageEntity.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    @PostMapping("/edit/mock")
    public JsonResult modifyMock(@RequestBody Mock mock) {
        return JsonResult.buildSuccessResult(mockService.saveOrUpdate(mock));
    }

    @GetMapping("/list/mock/module")
    public JsonResult getMockModuleList(Integer pageNum, Integer pageSize) {
        IPage<MockModule> page = new Page<>(pageNum, pageSize);
        IPage<MockModule> pageEntity = mockModuleService.page(page);
        Map<String, Object> map = new HashMap<>();
        map.put("list", pageEntity.getRecords());
        map.put("total", pageEntity.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    @PostMapping("/add/mock/module")
    public JsonResult addMockModule(@RequestBody MockModule mockModule) {
        return JsonResult.buildSuccessResult(mockModuleService.save(mockModule));
    }

    @PostMapping("/edit/mock/module")
    public JsonResult modifyMockModule(@RequestBody MockModule mockModule) {
        return JsonResult.buildSuccessResult(mockModuleService.saveOrUpdate(mockModule));
    }
}
