package cn.qg.holmes.entity.quality;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
@TableName(value = "ding_robot")
public class DingRobot {
    @TableId(type = IdType.AUTO)
    private Integer id;
    /**
     * 项目名称，与提BUG时【】里的内容进行匹配
     */
    private String projectName;
    /**
     * jira项目关键字
     */
    private String jiraProjectKey;
    /**
     * 钉钉机器人webhook
     */
    private String dingUrl;
    /**
     * 创建人
     */
    private String creator;
    /**
     * 环境
     */
    private String namespace;
    /**
     * 1-进行中，2-已完成
     */
    private Integer status;

    /**
     * 提测说明id
     */
    private Integer submitTestInstructionId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @TableField(exist = false)
    private String jiraProjectName;
}
