package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.entity.auth.RolePermission;
import cn.qg.holmes.mapper.auth.PermissionMapper;
import cn.qg.holmes.mapper.auth.RolePermissionMapper;
import cn.qg.holmes.service.auth.RolePermissionService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
public class RolePermissionServiceImpl extends ServiceImpl<RolePermissionMapper, RolePermission> implements RolePermissionService {

    @Autowired
    RolePermissionMapper rolePermissionMapper;

    @Autowired
    PermissionMapper permissionMapper;

    @Override
    public Set<String> getPermissionSetForRoleIds(List<Integer> roleIds) {
        Set<String> permissionCodeSet = new HashSet<>();
        for (Integer roleId: roleIds) {
            QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
            rolePermissionQueryWrapper.eq("role_id", roleId);
            List<RolePermission> rolePermissionList = rolePermissionMapper.selectList(rolePermissionQueryWrapper);
            rolePermissionList.forEach(rolePermission -> {
                permissionCodeSet.add(permissionMapper.selectById(rolePermission.getPermissionId()).getPermissionCode());
            });
        }
        return permissionCodeSet;
    }

    @Override
    public Set<String> getMenuSetForRoleIds(List<Integer> roleIds) {
        Set<String> menuCodeSet = new HashSet<>();
        for (Integer roleId: roleIds) {
            QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
            rolePermissionQueryWrapper.eq("role_id", roleId);
            List<RolePermission> rolePermissionList = rolePermissionMapper.selectList(rolePermissionQueryWrapper);
            rolePermissionList.forEach(rolePermission -> {
                menuCodeSet.add(permissionMapper.selectById(rolePermission.getPermissionId()).getMenuCode());
            });
        }
        return menuCodeSet;
    }
}
