package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.Role;
import cn.qg.holmes.service.auth.RoleService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/role")
public class RoleController {

    @Autowired
    RoleService roleService;

    /**
     * 获取角色列表
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getRoleList(@RequestParam Integer pageNum, @RequestParam Integer pageSize) {
        IPage<Role> roleIPage = new Page<>(pageNum, pageSize);
        IPage page = roleService.page(roleIPage);
        Map<String, Object> map = new HashMap<>();
        map.put("total", page.getTotal());
        map.put("list", page.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增角色
     * @param role 角色实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult addRole(@RequestBody Role role) {
        return JsonResult.buildSuccessResult(roleService.save(role));
    }

    /**
     * 编辑角色
     * @param role 角色实体
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editRole(@RequestBody Role role) {
        return JsonResult.buildSuccessResult(roleService.saveOrUpdate(role));
    }

    /**
     * 删除角色
     * @param roleId 角色id
     * @return
     */
    @PostMapping("/del")
    public JsonResult delRole(Integer roleId) {
        return JsonResult.buildSuccessResult(roleService.removeById(roleId));
    }
}
