package cn.qg.holmes.service.reconciliation;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.qg.holmes.entity.reconciliation.AliPayBillData;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayConfig;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 支付宝支付账单服务
 *
 * @author libo
 * 2022-02-22
 */
@Slf4j
@Component
public class AliPayBillService {

    private final String ALI_SERVER_URL = "https://openapi.alipay.com/gateway.do";
    private final String ALIPAY_PRIVATE_KEY = "MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC3rgHa/x67gaY08RJoeVWLghAiQooLG/dOojW+639RAuirhxLyeuawbcch291uj/90MPTQy86nNKKQBbet41MQtS8L6ts/5Bjp2GYgzsQlmPCRWE7Il94/6R18fg9ZZQ4rx280BrX60hKTFcM+rn6IuNAiT7wHMcsjonRLsbWW/ZaSmMwqJcfhRU2/8Slznw2AX8jHs3X/ZZtM8usm3Hd41U9m7DIRPgejo4wlgTmUrFJrgQIWdsuSCYm88a4BzFc3Wfa2No5stqkHZizsshx52UGOgvgJdxF6PUqC9af+qQSdldTcbOeQjgQbJOLfiZoPQzyO8DaszIzJkB8FB38DAgMBAAECggEBAIbZ7qzMjtCU3+SQdLZVFlQFGjk85sI/NvL5LkJL/T4Jx65eza9OQd2XyxH1rH1GpQK2CpbceozRnOPl/rNgaRSkILU8KNmgahYM9PXzN5huz3e2AKlOrjH3wNksZ7J2+c90bRUiNCrAXji0SpLTYzyXit8V8PLLQNuZoo4MG0iNCJy8riZwUn8ZQLJnCMv1VD0yUyGSr/6LAEJjJZTrrnpibw/99hqFO8Z6UvIs9JewfvjdzamT3UxF0gURSncieQwvsq3mYlq6ppcWqzBrEqJHZJOGzZrxtsOALmOFr7KCp6qRziareK/9vb9RLnZtBSrLZqhJF/MU1oFWpHixRoECgYEA3yKt0rT2v1rjaOlMQDF7pKKfnGmRHGps9214Smsj/wOwWdlwwixWZA2DUFLOUpPQRu3dPp3ZZQdcg21NejvEbtu4CcN0lrvnVlBIrExQmm9zqjDWijljtNvf+POqMkwyLumtNtdNxWLZxdiDClosShEX9kv4ttdlF5bEc2z3V8ECgYEA0rumR+zUnvT6OS6l6msUXgZ/f/XBgcW8BLdZV6pSJJVh3I9CVgc55MlTTGTd0yNfrDPVbwloDpjVVPSNI9YNL0h9i0vfMTHolWOR7RCcqBoquvt66NjtaV70PjBm1pxNVVDaUSgCva+oOFaRnoHjOSA+jyZkKRHjwnEWlcyRZ8MCgYBnZCtE6gM3cYbUEt35FLSk+ZGZqTTLBOlO0NOfL/vy6yOozl84KdEx9Sz2aBggHUuxwf/1RrD35ixQ3bG7xLvlXjvtkjqQqaqszPCPnaDvnlrq7kxKqgLwR72FHmqrebD7Gd3f/m2T25Tq3sMBZf0FqNwAjP1Gw5GdF4gZr9EAQQKBgQCQrWgxxTUMlOAd1hru3+kxzIBIl67sq5a0HjTmbPbMSwrO5EQE0B09J8NalX198bFDhqqn+utH6kG8e9FSoyiWJ8yZj9OB8OPffGa5PUhwWNaxXOo7ZoNIbnp9H7na6aBmTIY2ZaPMGwcA9t4u1rnrhGmu2gq176RQ4FdDLRk/BQKBgQDU+Oab3jL2MoDMtGk4ZGYQUcTMB/ILtG4O1bx8BhJZ/Rula3Rt7dYPrRng3uZ0sTVh7/QRSn02hLY72UoItge3POZMEbNQLb+gzhIuU4v4hLT3H6WK2MSaLftsb9mPyW9LX76xQS4ayf5xZqeKK2jOtIZCsiLmC/ALvIytcr2DHA==";
    private String format = "json";
    private String charset = "GBK";
    private String signType = "RSA2";
    private String aliAppId = "2021002106644714";
    private String merchantCertPath = "alipay/appCertPublicKey_2021002106644714.crt";
    private String alipayCertPath = "alipay/alipayCertPublicKey_RSA2.crt";
    private String alipayRootCertPath = "alipay/alipayRootCert.crt";

    /**
     * 业务账单下载路径
     */
    @Value("${alipay.file.path}")
    private String aliPayFilePath;

    private String FILE_NAME_CONTENT = "业务明细.csv";
    private String BILL_TYPE_REPAY = "交易";
    private String BILL_TYPE_REFUND = "退款";

    /**
     * 请求支付宝对账单下载接口
     *
     * @param billDate 账单日期，格式：2022-02-22
     * @return
     * @throws IOException
     * @throws AlipayApiException
     */
    public List<String> downloadBillFile(String billDate) throws IOException, AlipayApiException {
        log.info("开始下载支付宝对账文件，账单日期：{}", billDate);

        InputStream merchantCert = new ClassPathResource(merchantCertPath).getInputStream();
        InputStream alipayCert = new ClassPathResource(alipayCertPath).getInputStream();
        InputStream alipayRootCert = new ClassPathResource(alipayRootCertPath).getInputStream();

        AlipayConfig alipayConfig = new AlipayConfig();
        alipayConfig.setServerUrl(ALI_SERVER_URL);
        alipayConfig.setAppId(aliAppId);
        alipayConfig.setPrivateKey(ALIPAY_PRIVATE_KEY);
        alipayConfig.setAppCertContent(IOUtils.toString(merchantCert, String.valueOf(Charset.defaultCharset())));
        alipayConfig.setAlipayPublicCertContent(IOUtils.toString(alipayCert, String.valueOf(Charset.defaultCharset())));
        alipayConfig.setRootCertContent(IOUtils.toString(alipayRootCert, String.valueOf(Charset.defaultCharset())));
        alipayConfig.setFormat(format);
        alipayConfig.setCharset(charset);
        alipayConfig.setSignType(signType);

        DefaultAlipayClient alipayClient = new DefaultAlipayClient(alipayConfig);
        AlipayDataDataserviceBillDownloadurlQueryRequest request = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        JSONObject bizContent = new JSONObject();
        bizContent.put("bill_type", "trade");
        bizContent.put("bill_date", billDate);
        request.setBizContent(bizContent.toJSONString());
        AlipayDataDataserviceBillDownloadurlQueryResponse response = alipayClient.certificateExecute(request);
        return parseResponseResult(response);
    }

    /**
     * 处理响应结果，并下载对账文件
     *
     * @param response
     * @return
     */
    public List<String> parseResponseResult(AlipayDataDataserviceBillDownloadurlQueryResponse response) {
        if (!response.isSuccess()) {
            log.info("获取支付宝支付账单下载地址失败.");
            return null;
        }
        String downloadUrl = response.getBillDownloadUrl();
        log.info("获取支付宝支付账单下载地址成功，地址为：{}", downloadUrl);
        Map<String, String> urlParamMap = new HashMap<>();
        for (String prop : StringUtils.split(downloadUrl, "&")) {
            String[] splitVal = StringUtils.split(prop, "=");
            urlParamMap.put(splitVal[0], splitVal[1]);
        }

        StringBuilder tempFilePath = new StringBuilder(aliPayFilePath);

        String zipFilePath = tempFilePath.append(urlParamMap.get("downloadFileName")).toString();

        downloadFileFromURL(downloadUrl, zipFilePath);

        ZipUtil.unzip(zipFilePath, Charset.forName("gbk"));

        String filePath = zipFilePath.substring(0, zipFilePath.lastIndexOf("."));
        File file = new File(filePath);
        String[] fileList = file.list();
        String newFileName = StrUtil.EMPTY;
        for (String fileName : fileList) {
            if (fileName.contains(FILE_NAME_CONTENT)) {
                newFileName = fileName;
                break;
            }
        }
        //解压后文件所在路径
        String newFilePath = filePath + File.separator + newFileName;
        log.info("下载到支付宝对账文件路径:{}", newFilePath);
        return FileUtil.readLines(newFilePath, "gbk");
    }

    /**
     * 解析支付宝账单文件，转换成实体类列表
     *
     * @param billFile
     * @return
     */
    public List<AliPayBillData> parseAliPayBillFile(List<String> billFile) {
        log.info("开始解析支付宝账单文件.");
        List<AliPayBillData> aliPayBillDataList = new ArrayList<>();
        // 前五行和后四行不要
        for (int i = 5; i < billFile.size() - 4; i++) {
            String[] dataArray = billFile.get(i).replaceAll("\t", "").split(",");
            AliPayBillData aliPayBillData = new AliPayBillData();

            aliPayBillData.setAliPayTradeNo(dataArray[0]);
            aliPayBillData.setMerchantOrderNo(dataArray[1]);
            aliPayBillData.setTradeType(dataArray[2]);
            aliPayBillData.setTradeTime(dataArray[4]);
            if (StringUtils.equals(dataArray[2], BILL_TYPE_REPAY)) {
                aliPayBillData.setOrderAmount(dataArray[11]);
            }
            if (StringUtils.equals(dataArray[2], BILL_TYPE_REFUND)) {
                // 业务类型为退款时，去掉订单金额前面的负号
                aliPayBillData.setOrderAmount(dataArray[11].substring(1));
                // 业务类型退款时，设置退款批次号
                aliPayBillData.setRefundOrderNo(dataArray[21]);
            }
            // 商户实收金额
            aliPayBillData.setMerchantReceiveAmount(dataArray[12]);

            aliPayBillDataList.add(aliPayBillData);
        }
        log.info("开始解析支付宝账单文件结果：{}", aliPayBillDataList);
        return aliPayBillDataList;
    }

    @SneakyThrows
    public void downloadFileFromURL(String url, String filePath) {
        FileUtil.touch(filePath);
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        InputStream is = null;

        HttpURLConnection conn = null;
        try {
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection) httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Charset", "UTF-8");
            conn.connect();
            is = conn.getInputStream();

            bis = new BufferedInputStream(is);
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);

            byte[] buf = new byte[1024];
            int length = bis.read(buf);
            while (length != -1) {
                bos.write(buf, 0, length);
                length = bis.read(buf);
            }
            bos.close();
            bis.close();
            conn.disconnect();
        } catch (Exception e) {
            log.error("解析URL异常：{}", e, e.getMessage());
        }
    }

}
