package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.config.annotation.RequiresPermissions;
import cn.qg.holmes.entity.effect.BuildData;
import cn.qg.holmes.entity.effect.BuildDataDetail;
import cn.qg.holmes.service.effect.BuildDataDetailService;
import cn.qg.holmes.service.effect.BuildDataService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 造数据文档controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/build/data")
public class BuildDataController {

    @Autowired
    BuildDataService buildDataService;

    @Autowired
    BuildDataDetailService buildDataDetailService;

    /**
     * 获取造数据页面展示
     * @return
     */
    @GetMapping("/index")
    public JsonResult getBuildDataIndex() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<BuildData> buildDataList = buildDataService.list();
        QueryWrapper<BuildDataDetail> queryWrapper = new QueryWrapper<>();
        for (BuildData buildData: buildDataList) {
            Map<String, Object> map = new HashMap<>();
            Integer moduleId = buildData.getId();
            queryWrapper.eq("module", moduleId);
            List<BuildDataDetail> buildDataDetails = buildDataDetailService.list(queryWrapper);
            map.put("moduleId", moduleId);
            map.put("moduleName", buildData.getName());
            map.put("type", buildData.getColor());
            map.put("list", buildDataDetails);
            resultList.add(map);
            queryWrapper.clear();
        }
        return JsonResult.buildSuccessResult(resultList);
    }

    /**
     * 获取详情列表
     * @param name 造数据详情名称
     * @param module 模块id
     * @return
     */
    @GetMapping("/list")
    public JsonResult getBuildDataDetailList(String name, Integer module) {
        QueryWrapper<BuildDataDetail> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(name)) {
            queryWrapper.eq("name", name);
        }
        if (module != null) {
            queryWrapper.eq("module", module);
        }
        queryWrapper.orderByDesc("id");
        return JsonResult.buildSuccessResult(buildDataDetailService.list(queryWrapper));
    }

    /**
     * 返回造数据模块，不分页
     * @return
     */
    @GetMapping("/modules")
    public JsonResult getBuildDataModules() {
        return JsonResult.buildSuccessResult(buildDataService.list());
    }

    /**
     * 新增造数据详情
     * @param buildDataDetail
     * @return
     */
    @RequiresPermissions("build:data:add")
    @PostMapping("/add")
    public JsonResult addBuildDataDetail(@RequestBody BuildDataDetail buildDataDetail) {
        QueryWrapper<BuildDataDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq("name", buildDataDetail.getName())
                .eq("module", buildDataDetail.getModule());
        if (buildDataDetailService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("数据已存在，不能重复添加！", false);
        }
        return JsonResult.buildSuccessResult(buildDataDetailService.save(buildDataDetail));
    }

    /**
     * 更新造数据详情
     * @param buildDataDetail
     * @return
     */
    @RequiresPermissions("build:data:update")
    @PostMapping("/update")
    public JsonResult updateBuildDataDetail(@RequestBody BuildDataDetail buildDataDetail) {
        return JsonResult.buildSuccessResult(buildDataDetailService.updateById(buildDataDetail));
    }

    /**
     * 删除造数据详情
     * @param buildDataDetail
     * @return
     */
    @RequiresPermissions("build:data:delete")
    @PostMapping("/delete")
    public JsonResult deleteBuildDataDetail(@RequestBody BuildDataDetail buildDataDetail) {
        return JsonResult.buildSuccessResult(buildDataDetailService.removeById(buildDataDetail.getId()));
    }
}
