package cn.qg.holmes.service.effect;

import java.util.List;
import java.util.Map;

public interface DatabaseSyncService {

    boolean getDbInfoFromSource(String ip, String port, String username, String password, String dbName);

    boolean syncDbToDest(String ip, String port, String username, String password, String dbName, String namespace);

    boolean getSingleTableFromSource(String ip, String port, String username, String password, String dbName, String tableName);

    boolean syncSingleTableToDest(String ip, String port, String username, String password, String dbName, String tableName);

    List<Object> getDatabaseList(String ip, String port, String username, String password);

    Map<String, String> getMysqlInfoByNamespace(String namespace);

    List<Object> getTableListByDb(String ip, String port, String username, String password, String dbName);
}