package cn.qg.holmes.utils;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
//@Component
public class K8sService {

    private KubernetesClient kubernetesClient;

    public K8sService() {
        try {
            String configYAML = String.join("\n", readConfigFile("kube-config.yml"));
            Config config = Config.fromKubeconfig(configYAML);
            kubernetesClient = new DefaultKubernetesClient(config);
            String configCrt = String.join("\n", readConfigFile("tke-cluster-ca.crt"));
            config.setCaCertData(configCrt);
        } catch (Exception e) {
            log.info("k8s service 初始化失败！");
            e.printStackTrace();
        }

    }

    /**
     * 读取k8s配置文件
     * @param file 配置文件名
     * @return
     * @throws IOException
     */
    public static List<String> readConfigFile(String file) throws IOException {
        String str = "";
        ClassPathResource resource = new ClassPathResource(file);
        InputStream in = resource.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        List<String> result = new ArrayList<>();
        while ((str = br.readLine()) != null) {
            result.add(str);
        }
        return result;
    }

    /**
     * 获取namespace列表
     * @return
     */
    public List<Map<String, Object>> getNamespaceList() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<Namespace> namespaceList = kubernetesClient.namespaces().list().getItems();
        for (Namespace namespace: namespaceList) {
            log.info(namespace.toString());
            if (namespace.getMetadata().getAnnotations() != null) {
                Map<String, Object> map = new HashMap<>();
                map.put("name", namespace.getMetadata().getName());
                map.put("description", namespace.getMetadata().getAnnotations().get("description"));
                map.put("owner", namespace.getMetadata().getAnnotations().get("owner"));
                map.put("status", namespace.getStatus().getPhase());
                map.put("createdAt",namespace.getMetadata().getCreationTimestamp());
                resultList.add(map);
            }
        }
        return  resultList;
    }

}
