package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.AutoModule;
import cn.qg.holmes.entity.auto.Scene;
import cn.qg.holmes.entity.auto.Testcase;
import cn.qg.holmes.service.auto.AutoModuleService;
import cn.qg.holmes.service.auto.SceneService;
import cn.qg.holmes.service.auto.SceneTestcaseService;
import cn.qg.holmes.service.auto.TestcaseService;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * 测试用例执行controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/execute")
public class TestExecutionController {

    @Autowired
    TestcaseService testcaseService;

    @Autowired
    SceneTestcaseService sceneTestcaseService;

    @Autowired
    SceneService sceneService;

    @Autowired
    AutoModuleService autoModuleService;

    /**
     * 执行单个用例
     * @param namespace 环境
     * @param testcaseId 用例id
     * @return
     */
    @GetMapping("/testcase")
    public JsonResult executeSingleTestcase(@RequestParam String namespace, @RequestParam Integer testcaseId) {
        Testcase testcase = testcaseService.getById(testcaseId);
        String testcaseName = testcase.getName();
        Date date = new Date();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SS");
        String batch = dateFormat.format(date) + "_" + testcaseName;
        return JsonResult.buildSuccessResult(JSON.parseObject(testcaseService.singleTestcaseExecutor(namespace, testcaseId, batch), Map.class));
    }

    /**
     * 执行一个模块下所有用例
     * @param namespace 环境
     * @param moduleId 模块id
     * @return
     */
    @GetMapping("/module")
    public JsonResult executeTestcaseByModule(@RequestParam String namespace, @RequestParam Integer moduleId) {
        Date date = new Date();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SS");
        AutoModule autoModule = autoModuleService.getById(moduleId);
        String moduleName = autoModule.getName();
        String batch = dateFormat.format(date) + "_" + moduleName;
        return JsonResult.buildSuccessResult(JSON.parseArray(testcaseService.executeTestcaseByModuleId(namespace, moduleId, batch)));
    }

    /**
     * 执行场景用例
     * @param namespace 环境
     * @param sceneId 场景id
     * @return
     */
    @GetMapping("/scene")
    public JsonResult executeSceneTestcase(String namespace, Integer sceneId) {
        Date date = new Date();
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SS");
        Scene scene = sceneService.getById(sceneId);
        String batch = dateFormat.format(date) + "_" + scene.getName();
        return JsonResult.buildSuccessResult(JSON.parseArray(sceneTestcaseService.executeSceneTestcase(namespace, sceneId, batch)));
    }
}
