package cn.qg.holmes.controller.quality;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.quality.SubmitTestInstruction;
import cn.qg.holmes.service.quality.SubmitTestInstructionService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 质量管理相关接口
 * @author libo
 * 2021-10-29
 */
@RestController
@RequestMapping("/quality")
public class QualityController {

    @Autowired
    SubmitTestInstructionService instructionService;

    /**
     * 提测说明分页列表
     * @param projectName 项目名称
     * @param jiraProjectKey jira项目关键字
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/testInstruction/list")
    public JsonResult getSubmitTestInstructionList(String projectName, String jiraProjectKey,
                                                   @RequestParam(defaultValue = "1") Integer pageNum,
                                                   @RequestParam(defaultValue = "10") Integer pageSize) {
        QueryWrapper<SubmitTestInstruction> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(projectName)) {
            queryWrapper.eq("project_name", projectName);
        }
        if (!StringUtils.isEmpty(jiraProjectKey)) {
            queryWrapper.eq("jira_project_key", jiraProjectKey);
        }
        IPage<SubmitTestInstruction> instructionIPage = new Page<>(pageNum, pageSize);
        IPage<SubmitTestInstruction> page = instructionService.page(instructionIPage, queryWrapper);
        Map<String, Object> map = new HashMap<>();
        map.put("list", page.getRecords());
        map.put("total", page.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增提测说明
     * @param submitTestInstruction 提测说明实体类
     * @return
     */
    @PostMapping("/testInstruction/save")
    public JsonResult saveSubmitTestInstruction(@RequestBody SubmitTestInstruction submitTestInstruction) {
        String projectName = submitTestInstruction.getProjectName();
        String jiraProjectKey = submitTestInstruction.getJiraProjectKey();
        QueryWrapper<SubmitTestInstruction> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_name", projectName);
        queryWrapper.eq("jira_project_key", jiraProjectKey);
        if (instructionService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("项目已存在，无法创建！", false);
        }
        return JsonResult.buildSuccessResult("项目创建成功！", instructionService.save(submitTestInstruction));
    }

    /**
     * 更新提测说明
     * @param submitTestInstruction 提测说明实体
     * @return
     */
    @PostMapping("/testInstruction/update")
    public JsonResult updateSubmitTestInstruction(@RequestBody SubmitTestInstruction submitTestInstruction) {
        return JsonResult.buildSuccessResult("更新成功!", instructionService.saveOrUpdate(submitTestInstruction));
    }

    /**
     * 删除提测说明
     * @param submitTestInstruction 提测说明实体
     * @return
     */
    @PostMapping("/testInstruction/delete")
    public JsonResult deleteSubmitTestInstruction(@RequestBody SubmitTestInstruction submitTestInstruction) {
        return JsonResult.buildSuccessResult("删除成功！", instructionService.removeById(submitTestInstruction.getId()));
    }

    /**
     * 根据jira项目关键字获取项目名称
     * @param jiraProjectKey jira项目关键字，例如APP
     * @return
     */
    @GetMapping("/testInstruction/getProjectNameList")
    public JsonResult getTestInstructionListForQaProcess(@RequestParam String jiraProjectKey) {
        QueryWrapper<SubmitTestInstruction> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("jira_project_key", jiraProjectKey);
        return JsonResult.buildSuccessResult("获取项目列表成功", instructionService.list(queryWrapper));
    }

    /**
     * 获取详情
     * @param projectName 项目名称
     * @param jiraProjectKey jira项目关键字
     * @return
     */
    @GetMapping("/testInstruction/detail")
    public JsonResult getTestInstructionDetail(@RequestParam String projectName, @RequestParam String jiraProjectKey) {
        QueryWrapper<SubmitTestInstruction>  queryWrapper = new QueryWrapper<>();
        queryWrapper
                .eq("project_name", projectName)
                .eq("jira_project_key", jiraProjectKey);
        return JsonResult.buildSuccessResult(instructionService.getOne(queryWrapper));
    }
}
