package cn.qg.holmes.service.auto.impl;

import cn.qg.holmes.entity.auto.AutoModule;
import cn.qg.holmes.entity.auto.Interface;
import cn.qg.holmes.mapper.auto.InterfaceMapper;
import cn.qg.holmes.service.auto.InterfaceService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 自动化-接口相关service
 * @author libo
 */
@Service
public class InterfaceServiceImpl extends ServiceImpl<InterfaceMapper, Interface> implements InterfaceService {

    @Autowired
    InterfaceMapper interfaceMapper;

    @Override
    public IPage<Interface> getInterfaceList(Integer projectId, Integer moduleId, Integer pageNum, Integer pageSize) {
        IPage<Interface> page = new Page<>(pageNum, pageSize);
        IPage<Interface> interfaceIPage = interfaceMapper.getInterfaceList(page, projectId, moduleId);
        return interfaceIPage;
    }
}
