package cn.qg.holmes.entity.effect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 造数据详情实体类
 */
@TableName(value = "build_data_detail")
@Data
public class BuildDataDetail {

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 造数据说明
     */
    @TableField(value = "name")
    @NotBlank(message = "名称不能为空")
    private String name;

    /**
     * 链接地址
     */
    @TableField(value = "url")
    @NotBlank(message = "链接名称不能为空")
    private String url;

    /**
     * 模块id
     */
    @TableField(value = "module")
    @NotNull(message = "模块id不能为空")
    private Integer module;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @TableField(exist = false)
    private String moduleName;
}
