package cn.qg.holmes.utils;

import com.alibaba.fastjson.JSON;
import com.atlassian.jira.rest.client.api.domain.Issue;
import lombok.extern.slf4j.Slf4j;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
public class DingdingUtils {

    public static boolean sendToDingding(String jsonString, String webhook) {
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        String result = HttpClientUtils.doPostJson(webhook, headers, jsonString);
        log.info("发送给钉钉: {}, 内容：{}, 钉钉返回结果：{}", webhook, jsonString, result);
        Map<String, String> resultMap = JSON.parseObject(result, Map.class);
        return resultMap.get("errmsg").equals("ok");
    }

    public static String buildMarkdownMsg(String key, String summary, String creator, String assignee, String priority, String module) {
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> content = new HashMap<>();
        markdown.put("msgtype", "markdown");
        String title = creator + "提交了BUG：" + key;
        String issueUrl = "http://jira2.quantgroup.cn/browse/" + key;
        content.put("title", title);
        content.put("text", "#### " + title + "\n"
                + "#### 概要：[" + summary + "](" + issueUrl + ")"+ "\n"
                + "- 优先级：" + priority + "\n"
                + "- 模块：" + module + "\n"
                + "- 经办人：" + assignee);
        markdown.put("markdown", content);
        return JSON.toJSONString(markdown);
    }

    /**
     * 根据issueList构建未解决issueList的markdown格式
     * @param issues Issue的迭代器
     * @return
     */
    public static String buildMarkdownMsgForUnsolvedIssueList(Iterable<Issue> issues) {
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> contentMap = new HashMap<>();
        Map<String, Object> atMap = new HashMap<>();
        atMap.put("isAtAll", true);
        markdown.put("at", atMap);
        List<Issue> issueList = new ArrayList<>();
        for (Issue issue: issues) {
            issueList.add(issue);
        }
        markdown.put("msgtype", "markdown");
        contentMap.put("title", "今日剩余未解决BUG统计");
        String content = "#### 今日剩余未解决BUG数：" + issueList.size() + "\n";
        int count = 0;
        for (Issue issue: issueList) {
            count = count + 1;
            String issueUrl = "http://jira2.quantgroup.cn/browse/" + issue.getKey();
            content = content + count + "、[" + issue.getSummary().replace("\"", "") + "](" + issueUrl + ")\n";
            content = content + "- 优先级：" + issue.getPriority().getName() + "\n";
            content = content + "- 状态：" + issue.getStatus().getName() + "\n";
            content = content + "- 经办人：" + issue.getAssignee().getDisplayName() + "\n\n";
        }
        contentMap.put("text", content);
        markdown.put("markdown", contentMap);
        return JSON.toJSONString(markdown);
    }

    public static String buildTestScheduleMarkdownMsg(Iterable<Issue> issues, String progress, String risk) {
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> contentMap = new HashMap<>();
        Map<String, Object> atMap = new HashMap<>();
        atMap.put("isAtAll", true);
        markdown.put("at", atMap);
        List<Issue> issueList = new ArrayList<>();
        for (Issue issue: issues) {
            issueList.add(issue);
        }
        markdown.put("msgtype", "markdown");
        Date date=new Date();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        contentMap.put("title", format.format(date) + "今日测试进度汇报");
        String content = format.format(date) + "\n\n";
        content +=  "今日测试进度：" + progress + " \n\n";
        content = content + "剩余未解决BUG列表：" + "\n\n";
        if (issueList.size() == 0) {
            content += "暂无未解决BUG！";
        }
        int count = 0;
        for (Issue issue: issueList) {
            count += 1;
            String issueUrl = "http://jira2.quantgroup.cn/browse/" + issue.getKey();
            content = content + count + "、[" + issue.getSummary().replace("\"", "") + "](" + issueUrl + ")\n";
            content = content + "- 优先级：" + issue.getPriority().getName() + "\n";
            content = content + "- 状态：" + issue.getStatus().getName() + "\n";
            content = content + "- 经办人：" + issue.getAssignee().getDisplayName() + "\n\n";
        }
        if (risk != null && !risk.isEmpty()) {
            content =  content + "**风险：" + risk + "**\n";
        }
        contentMap.put("text", content);
        markdown.put("markdown", contentMap);
        return JSON.toJSONString(markdown);
    }

    /**
     * 构建BUG fix 提醒消息
     * @param issue Jira Issue
     * @return
     */
    public static String buildBugFixRemindMsg(Issue issue) {
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> contentMap = new HashMap<>();
        Map<String, Object> atMap = new HashMap<>();
        atMap.put("isAtAll", true);
        markdown.put("at", atMap);
        markdown.put("msgtype", "markdown");
        contentMap.put("title", "BUG修复提醒");
        String content = "亲爱的" + issue.getAssignee().getName() + "同学，你有一个BUG已经超过4个小时未解决，请多注意哦！\n\n";
        String bugUrl = "http://jira2.quantgroup.cn/browse/" + issue.getKey();
        content += "BUG具体信息：[" + issue.getSummary().replace("\"", "") + "](" + bugUrl + ")\n\n";
        contentMap.put("text", content);
        markdown.put("markdown", contentMap);
        return JSON.toJSONString(markdown);
    }

    public static void main(String[] args) {
//        String markdown = buildMarkdownMsg("YXM-1499", "【羊小咩v7.6.00】【VCC首次交易率提升专题】巴拉巴拉", "黎博", "于巧玲", "p1", "kddsp");
//        sendToDingding(markdown, "https://oapi.dingtalk.com/robot/send?access_token=835663338d638e40daaf3ab358af741ef0680a826a962c91bedc53b149d85ee1");
    }
}
