package cn.qg.holmes.controller.k8s;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.utils.K8sService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/k8s")
public class K8sController {

    @Autowired
    K8sService k8sService;

    /**
     * 获取namespace列表
     * @return
     */
    @GetMapping("/namespace")
    public JsonResult getNamespaceList() {
        return JsonResult.buildSuccessResult(k8sService.getNamespaceList());
    }

    /**
     * 获取pod列表
     * @param namespace 环境
     * @return
     */
    @GetMapping("/pod/list")
    public JsonResult getServiceList(@RequestParam String namespace) {
        List<Map<String, Object>> podList = k8sService.getPodList(namespace);
        return JsonResult.buildSuccessResult(podList);
    }
}
