package cn.qg.holmes.entity.jira;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

/**
 * 未解决JIRA BUG
 */
@Data
public class JiraBugPool {
    @TableId(type = IdType.AUTO)
    private Integer id;
    /**
     * jira关键字
     */
    @TableField("`key`")
    private String key;
    /**
     * bug标题
     */
    private String summary;
    /**
     * bug优先级
     */
    private String priority;
    /**
     * 报告人
     */
    private String reporter;
    /**
     * 经办人
     */
    private String assignee;
    /**
     * bug链接
     */
    private String url;
    /**
     * 钉钉robot
     */
    private String dingUrl;
    /**
     * 解决结果
     */
    private String resolveResult;
    /**
     * 是否有效，1-有效，0-无效
     */
    private Integer enable;
}
