package cn.qg.holmes.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

@Slf4j
public class DingdingUtils {

    public static boolean sendToDingding(String jsonString, String webhook) {
        Map<String, Object> headers = new HashMap<>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        JSONObject result = HttpClientUtils.doPostJson(webhook, jsonString, headers);
        log.info("发送给钉钉: {}, 内容：{}, 钉钉返回结果：{}", webhook, jsonString, result);
        return result.get("errmsg").equals("ok");
    }

    public static String buildMarkdownMsg(String key, String summary, String creator, String assignee, String priority) {
        Map<String, Object> markdown = new HashMap<>();
        Map<String, String> content = new HashMap<>();
        markdown.put("msgtype", "markdown");
        String title = creator + "提交了BUG：" + key;
        String issueUrl = "http://jira2.quantgroup.cn/browse/" + key;
        content.put("title", title);
        content.put("text", "### " + title + "\n" + "#### 概要：[" + summary + "](" + issueUrl + ")"+ "\n" + "- 优先级：" + priority + "\n" + "- 经办人：" + assignee);
        markdown.put("markdown", content);
        return JSON.toJSONString(markdown);
    }
}
