package cn.qg.holmes.controller.gitlab;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.utils.JenkinsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/jenkins")
public class JenkinsController {

    @Autowired
    JenkinsService jenkinsService;

    /**
     * 构建指定的jenkins job
     * @param type 类型，java/ui/node
     * @param project 项目名
     * @param branch 分支名
     * @param namespace 环境
     * @return
     */
    @GetMapping("/build")
    public JsonResult buildSpecifiedJob(@RequestParam String type,
                                        @RequestParam String project,
                                        @RequestParam String branch,
                                        @RequestParam String namespace) {
        try {
            log.info("开始构建jenkins项目：项目类型：{}, 项目名：{}, 分支：{}, 部署至环境：{}", type, project, branch, namespace);
            jenkinsService.buildJenkinsJob(type, project, branch, namespace);
            return JsonResult.buildSuccessResult(true);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("构建失败！", false);
        }
    }
}
