package cn.qg.holmes.entity.mock.keystone;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ProductItem {

    /**
     * skuId
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    /**
     * SKU名称
     */
    private String name;

    /**
     * SKU编码-三方渠道为起对应的skuId，自营商品手工输入
     */
    private String thirdSkuNo;

    /**
     * 商品Id
     */
    private Long productId;

    /**
     * 售价 出价
     */
    private BigDecimal salePrice;

    /**
     * 供货价 进价
     */
    @TableField(exist = false)
    private BigDecimal supplyPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 规格属性,存放为JSON字符串
     */
    private String specProps;

    /**
     * 规格的图片,如果没有则为null
     */
    private String image;
    /**
     * sku重量 单位：kg
     */
    private BigDecimal weight;

    /**
     * 详情图
     */
    private String primaryImage;

    /**
     * 下架原因id
     */
    private Long offSaleItemId;

    /**
     * 为了透传
     */
    @TableField(exist = false)
    private Integer stock;

    /**
     * 实际销量
     */
    @TableField(exist = false)
    private Integer actualSales;

    /**
     * 销量(含取消)
     */
    @TableField(exist = false)
    private Integer sales;

    /**
     * 5:未上架,6:上架,7:下架
     */
    private Integer state;

    /**
     * 上架时间
     */
    private LocalDateTime pushedAt;

    /**
     * 下架时间
     */
    private LocalDateTime offlineAt;

    /**
     * 创建人
     */
    private String createdBy;

    /**
     * 更新人
     */
    private String updatedBy;

    /**
     * 供应商类型
     */
    private String supplierType;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE, update = "now()")
    private LocalDateTime updatedAt;


    /**
     * 为了透传
     */
    @TableField(exist = false)
    private List<String> imageList;

    /**
     * 为了透传
     */
    @TableField(exist = false)
    private String skuLink;
    /**
     * 库存预警值
     */
    @TableField(exist = false)
    private Integer productStockWarning;
}
