package cn.qg.holmes.controller.gitlab;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.service.k8s.DockerProjectService;
import cn.qg.holmes.utils.GitlabService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/gitlab")
public class GitlabController {

    @Autowired
    GitlabService gitlabService;

    @Autowired
    DockerProjectService dockerProjectService;

    /**
     * 获取项目名列表
     * @return
     */
    @GetMapping("/projects")
    public JsonResult getProjectsList() {
        List<Map<String, String>> serviceList = new ArrayList<>();
        QueryWrapper<DockerProject> dockerProjectQueryWrapper = new QueryWrapper<>();
        dockerProjectQueryWrapper
                .eq("is_active", 1)
                .eq("project_type", "java")
                .orderByAsc("project_name");
        List<DockerProject> dockerProjectList = dockerProjectService.list(dockerProjectQueryWrapper);
        for (DockerProject dockerProject: dockerProjectList) {
            Map<String, String> map = new HashMap<>();
            map.put("name", dockerProject.getProjectName());
            map.put("type", dockerProject.getProjectType());
            serviceList.add(map);
        }
        dockerProjectQueryWrapper.clear();
        dockerProjectList.clear();
        dockerProjectQueryWrapper
                .eq("is_active", 1)
                .eq("project_type", "ui")
                .orderByAsc("project_name");
        dockerProjectList = dockerProjectService.list(dockerProjectQueryWrapper);
        for (DockerProject dockerProject: dockerProjectList) {
            Map<String, String> map = new HashMap<>();
            map.put("name", dockerProject.getProjectName());
            map.put("type", dockerProject.getProjectType());
            serviceList.add(map);
        }
        dockerProjectQueryWrapper.clear();
        dockerProjectList.clear();
        dockerProjectQueryWrapper
                .eq("is_active", 1)
                .eq("project_type", "node")
                .orderByAsc("project_name");
        dockerProjectList = dockerProjectService.list(dockerProjectQueryWrapper);
        for (DockerProject dockerProject: dockerProjectList) {
            Map<String, String> map = new HashMap<>();
            map.put("name", dockerProject.getProjectName());
            map.put("type", dockerProject.getProjectType());
            serviceList.add(map);
        }
        return JsonResult.buildSuccessResult(serviceList);
    }

    /**
     * 根据项目名获取分支列表
     * @param projectName 项目名
     * @return
     */
    @GetMapping("/branches")
    public JsonResult getBranchesByProject(String projectName) {
        List<Map> branchList = gitlabService.getBranchesByProjectNameByRestApi(projectName);
        if (branchList == null) {
            return JsonResult.buildErrorStateResult("请检查项目名称或项目配置是否正确！", false);
        }
        return JsonResult.buildSuccessResult(branchList);
    }
}
