package cn.qg.holmes.entity.mock.keystone.jdbuy;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 9.8 查询售后申请单明细
 */
@Data
public class AfsApplyDetailResponse extends JdBaseResponse{

    private AfsApplyDetailDto result;

    @Data
    public static class AfsApplyDetailDto{
        private List<AfsRefundInfoResultDto> refundInfoResultDtos;   //申请单维度退款明细
        private List<AddressInfoDto> addressInfoDtos;   //客户送货售后方式时邮寄地址
    }

    @Data
    public static class AfsRefundInfoResultDto {
        private String thirdApplyId;  //客售后申请单号
        private String originalOrderId;  //京东订单号
        private BigDecimal refundAmount;  //退款⾦额
        //@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        private Date modifyDate;  //完成时间
        private List<RefundDetailVo> refundDetailDtos;  //退款明细
        private List<RefundPayVo> refundPayDtos; //退款明细涉及的⽀付信息
        private List<RefundWareVo> refundWareDtos; //退款商品明细
    }

    @Data
    public static class RefundDetailVo{
        private String refundSourceId;   //申请单退款明细ID：与⽀付实体中⼀致
        private String payId;  //⽀付单号
        private Integer refundType;  //退款类型
        private Integer refundJdBankId;  //退款平台编号
        private String refundJdBankName;  //退款银⾏名称（⼯商银⾏，招商银⾏等）
        private BigDecimal refundAmount;  //退款⾦额
        private Long simpleCodeBankId;  //公司账号银⾏简码ID
    }

    @Data
    public static class RefundPayVo{
        private String refundSourceId;  //申请单退款明细ID：与⽀付实体中⼀致
        private String payId;  //⽀付单号
        private Integer  payType;  //⽀付类型
        private Integer payEnum;  //⽀付枚举
        private Integer payFlag;  //个⼈或企业，1:个⼈;2:企业
        private Integer busPayType;  //企业⽀付⽅式，混合⽀付必填
        private BigDecimal refundableAmount;  //涉及到退款⾦额
    }

    @Data
    public static class RefundWareVo{
        private String skuId;  //商品编号
        private String skuName;  //商品名称
        private Integer wareNumber;  //商品数量
    }

    @Data
    public static class AddressInfoDto{
        private String customerPin;  //企业PIN
        private Long orderId;  //订单号
        private Long newOrderId;  //换新订单号
        private Long originalOrderId;  //原始订单号
        private String thirdApplyId;  //三方申请单号
        private Integer afterserviceType;  //售后类型
        private Integer afterserviceProvince;  //售后省份
        private Integer afterserviceCity;  //售后城市
        private Integer afterserviceCounty;  //售后县城
        private Integer afterserviceVillage;  //售后城镇
        private String  afterserviceAddress;  //售后地址
        private String afterserviceReceiver;  //售后收货人
        private String afterserviceTel;  //售后收货人电话
        private String afterserviceZipcode;  //售后邮编
        private String afterservicePhone;  //售后电话

    }
}
