package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.entity.auth.UserInfoVo;
import cn.qg.holmes.mapper.auth.UserMapper;
import cn.qg.holmes.service.auth.TokenService;
import cn.qg.holmes.service.auth.UserService;
import cn.qg.holmes.utils.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Slf4j
@Service
public class TokenServiceImpl implements TokenService {

    private final String TOKEN_PREFIX = "user:token:";

    @Autowired
    RedisUtils redisUtils;

    @Autowired
    UserMapper userMapper;

    @Autowired
    UserService userService;

    /**
     * 生成token并存放到redis
     * @param userId 用户id
     * @return
     */
    @Override
    public String generateToken(Integer userId) {
        String token = UUID.randomUUID().toString().replace("-", "").substring(0, 20);
        User user = userMapper.selectById(userId);
        UserInfoVo userInfoVo = userService.getUserInfoByUsername(user.getUsername());
        //设置用户信息缓存
        redisUtils.set(TOKEN_PREFIX + token, userInfoVo);
        return token;
    }

    /**
     * 根据token从redis获取用户信息
     * @param token 用户token
     * @return
     */
    @Override
    public UserInfoVo getUserInfoFromCache(String token) {
        if (StringUtils.isEmpty(token)) {
            return null;
        }
        UserInfoVo userInfoVo = new UserInfoVo();
        Map redisValue = (Map) redisUtils.get(TOKEN_PREFIX + token);
        userInfoVo.setUserId((Integer) redisValue.get("userId"));
        userInfoVo.setUsername(redisValue.get("username").toString());
        userInfoVo.setRoleIds((List<Integer>) redisValue.get("roleIds"));
        Set<String> permissionCodeSet = new HashSet<>();
        List<String> permissionCodeList = (List<String>) redisValue.get("permissionCodeList");
        permissionCodeList.forEach(permissionCode -> {
            permissionCodeSet.add(permissionCode);
        });
        Set<String> menuSet = new HashSet<>();
        List<String> menuList = (List<String>) redisValue.get("menuList");
        menuList.forEach(menu -> {
            menuSet.add(menu);
        });
        userInfoVo.setPermissionCodeList(permissionCodeSet);
        userInfoVo.setMenuList(menuSet);
        return userInfoVo;
    }

    @Override
    public void invalidateToken(String token) {
        redisUtils.del(TOKEN_PREFIX + token);
    }

}
