package cn.qg.holmes.entity.jira;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 未解决JIRA BUG
 */
@Data
public class JiraBugPool {
    @TableId(type = IdType.AUTO)
    private Integer id;
    /**
     * jira关键字
     */
    @TableField("`key`")
    private String key;
    /**
     * bug标题
     */
    private String summary;
    /**
     * bug优先级
     */
    private String priority;
    /**
     * 报告人
     */
    private String reporter;
    /**
     * 经办人
     */
    private String assignee;
    /**
     * bug链接
     */
    private String url;
    /**
     * 钉钉robot
     */
    private String dingUrl;
    /**
     * 是否有效，1-有效，0-无效
     */
    private Integer enable;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
