package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.AutoModule;
import cn.qg.holmes.service.auto.AutoModuleService;
import cn.qg.holmes.service.auto.AutoProjectService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接口自动化模块controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/auto/module")
public class AutoModuleController {

    @Autowired
    AutoModuleService autoModuleService;

    @Autowired
    AutoProjectService autoProjectService;

    /**
     * 获取接口自动化模块列表
     * @param pageNum 第几页
     * @param pageSize 每页第几个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getAutoModuleList(Integer pageNum, Integer pageSize, Integer projectId) {
        IPage<AutoModule> autoModuleIPage = autoModuleService.getAutoModuleList(pageNum, pageSize, projectId);
        Map<String, Object> map = new HashMap<>();
        map.put("total", autoModuleIPage.getTotal());
        map.put("list", autoModuleIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增模块
     * @param autoModule AutoModule实体类
     * @return
     */
    @PostMapping("/add")
    public JsonResult addAutoModule(@RequestBody AutoModule autoModule) {
        QueryWrapper<AutoModule> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("name", autoModule.getName());
        if (autoProjectService.getById(autoModule.getProjectId()) == null) {
            return JsonResult.buildErrorStateResult("所选项目不存在！", false);
        } else if (autoModuleService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("模块已存在！", false);
        } else {
            return JsonResult.buildSuccessResult(autoModuleService.save(autoModule));
        }
    }

    /**
     * 修改模块
     * @param autoModule AutoModule实体类
     * @return
     */
    @PostMapping("/modify")
    public JsonResult editAutoModule(@RequestBody AutoModule autoModule) {
        QueryWrapper<AutoModule> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("name", autoModule.getName());
        queryWrapper.ne("id", autoModule.getId());
        if (autoModuleService.getById(autoModule.getId()) == null) {
            return JsonResult.buildErrorStateResult("模块不存在！", false);
        } else if (autoModuleService.getOne(queryWrapper) != null) {
            return JsonResult.buildErrorStateResult("该模块名已存在！", false);
        } else {
            return JsonResult.buildSuccessResult(autoModuleService.updateById(autoModule));
        }
    }

    /**
     * 删除模块
     * @param moduleId 模块id
     */
    @GetMapping("/delete")
    public JsonResult deleteAutoModule(@RequestParam Integer moduleId) {
        if (autoModuleService.getById(moduleId) == null) {
            return JsonResult.buildErrorStateResult("模块不存在", false);
        } else {
            return JsonResult.buildSuccessResult(autoModuleService.removeById(moduleId));
        }
    }
}
