package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.RolePermission;
import cn.qg.holmes.service.auth.RolePermissionService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@CrossOrigin
@RestController
@RequestMapping("/role/permission")
public class RolePermissionController {

    @Autowired
    RolePermissionService rolePermissionService;

    /**
     * 新增角色权限
     * @param roleId 角色id
     * @param permissionIdList 权限id列表
     * @return
     */
    @PostMapping("/add")
    public JsonResult addRolePermission(Integer roleId, List<Integer> permissionIdList) {
        List<RolePermission> rolePermissionList = new ArrayList<>();
        permissionIdList.forEach(permissionId -> {
            RolePermission rolePermission = new RolePermission();
            rolePermission.setRoleId(roleId);
            rolePermission.setPermissionId(permissionId);
            rolePermissionList.add(rolePermission);
        });
        return JsonResult.buildSuccessResult(rolePermissionService.saveBatch(rolePermissionList));
    }

    /**
     * 编辑角色权限
     * @param rolePermissionList 角色权限列表
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editRolePermission(List<RolePermission> rolePermissionList) {
        // todo 角色权限编辑
        return JsonResult.buildSuccessResult(rolePermissionService.saveOrUpdateBatch(rolePermissionList));
    }

    /**
     * 删除角色权限
     * @param rolePermissionId 角色权限
     * @return
     */
    @GetMapping("/del")
    public JsonResult delRolePermission(Integer rolePermissionId) {
        return JsonResult.buildSuccessResult(rolePermissionService.removeById(rolePermissionId));
    }
}
