package cn.qg.holmes.controller.navigate;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.navigate.NavigateDetail;
import cn.qg.holmes.entity.navigate.NavigateModule;
import cn.qg.holmes.service.navigate.NavigateDetailService;
import cn.qg.holmes.service.navigate.NavigateModuleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 导航controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/navigate")
public class NavigateController {

    @Autowired
    NavigateModuleService navigateModuleService;

    @Autowired
    NavigateDetailService navigateDetailService;

    /**
     * 获取导航列表
     * @return
     */
    @GetMapping("/index")
    public JsonResult getNavigateIndexUrl() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<NavigateModule> navigateModuleList = navigateModuleService.list();
        QueryWrapper<NavigateDetail> detailQueryWrapper = new QueryWrapper<>();
        for (NavigateModule navigateModule: navigateModuleList) {
            Map<String, Object> map = new HashMap<>();
            Integer moduleId = navigateModule.getId();
            detailQueryWrapper.eq("module", moduleId);
            List<NavigateDetail> navigateDetailList = navigateDetailService.list(detailQueryWrapper);
            map.put("moduleId", moduleId);
            map.put("moduleName", navigateModule.getName());
            map.put("type", navigateModule.getColor());
            map.put("list", navigateDetailList);
            resultList.add(map);
            detailQueryWrapper.clear();
        }
        return JsonResult.buildSuccessResult(resultList);
    }

    @GetMapping("/list")
    public JsonResult getNavigateList(String name, Integer module) {
        QueryWrapper<NavigateDetail> detailQueryWrapper = new QueryWrapper<>();
        if (name != null && !StringUtils.isEmpty(name)) {
            detailQueryWrapper.eq("name", name);
        }
        if (module != null) {
            detailQueryWrapper.eq("module", module);
        }
        List<NavigateModule> navigateModuleList = navigateModuleService.list();
        // 模块列表转对象
        Map<Integer, String> moduleMap =navigateModuleList.stream().collect(Collectors.toMap(NavigateModule::getId, NavigateModule::getName));
        // 获取导航列表
        List<NavigateDetail> navigateDetailList = navigateDetailService.list(detailQueryWrapper);
        for (NavigateDetail navigateDetail: navigateDetailList) {
            navigateDetail.setModuleName(moduleMap.get(navigateDetail.getModule()));
        }
        return JsonResult.buildSuccessResult(navigateDetailList);
    }

    /**
     * 获取导航模块
     * @return
     */
    @GetMapping("/modules")
    public JsonResult getNavigateModuleList() {
        return JsonResult.buildSuccessResult(navigateModuleService.list());
    }

    /**
     * 新增导航
     * @param navigateDetail
     * @return
     */
    @PostMapping("/add")
    public JsonResult addNavigate(@RequestBody NavigateDetail navigateDetail) {
        return JsonResult.buildSuccessResult(navigateDetailService.save(navigateDetail));
    }

    /**
     * 更新导航
     * @param navigateDetail
     * @return
     */
    @PostMapping("/update")
    public JsonResult editNavigate(@RequestBody NavigateDetail navigateDetail) {
        return JsonResult.buildSuccessResult(navigateDetailService.saveOrUpdate(navigateDetail));
    }

    /**
     * 删除导航
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public JsonResult delNavigate(Integer id) {
        return JsonResult.buildSuccessResult(navigateDetailService.removeById(id));
    }
}
