package cn.qg.holmes.entity.mock.keystone;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 提交订单到京东接口，mock返回结果中的sku实体类
 * @author libo
 * 2022-03-01
 */
@Data
public class BizSku {

    /**
     * 京东商品编号
     */
    private Long skuId;

    /**
     * 购买商品数量
     */
    private Integer num;

    /**
     * 商品分类编号
     */
    private Integer category;

    /**
     * 商品单价
     */
    private BigDecimal price;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 商品税率
     */
    private BigDecimal tax;

    /**
     * 商品税额
     */
    private BigDecimal taxPrice;

    /**
     * 商品未税价
     */
    private BigDecimal nakedPrice;

    /**
     * 商品类型：0普通、1附件、2赠品、3延保
     */
    private Integer type;

    /**
     * 主商品skuid，如果本身是主商品，则oid为0
     */
    private Long oid;
}
