package cn.qg.holmes.config;

import cn.qg.holmes.interceptor.RuleEngineInterceptor;
import cn.qg.holmes.interceptor.XinchengInterceptor;
import cn.qg.holmes.interceptor.YeebaoInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 拦截器，用于Mock
 */
@Configuration
public class InterceptorConfig implements WebMvcConfigurer {

    @Bean
    public YeebaoInterceptor yeebaoInterceptor() {
        return new YeebaoInterceptor();
    }

    @Bean
    public RuleEngineInterceptor ruleEngineInterceptor() {
        return new RuleEngineInterceptor();
    }

    @Bean
    public XinchengInterceptor xinchengInterceptor() {
        return new XinchengInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(yeebaoInterceptor()).addPathPatterns("/tzt-api/**", "/balance-board/**");
        registry.addInterceptor(ruleEngineInterceptor()).addPathPatterns("/rule_engine/**");
        registry.addInterceptor(xinchengInterceptor()).addPathPatterns("/webservice/api/lhp/**");
    }
}
