package cn.qg.holmes.entity.mock.keystone.jdbuy;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class SubmitOrderRequest {

    /**
     * 第三方订单号
     */
    private String thirdOrder;

    /**
     * 下单商品信息
     */
    private String sku;

    /**
     * 收件人姓名
     */
    private String name;

    /**
     * 一级地址
     */
    private Long province;

    /**
     * 二级地址
     */
    private Long city;

    /**
     * 三级地址
     */
    private Long county;

    /**
     * 四级地址
     */
    private Long town = 0L;

    /**
     * 收货人详细地址
     */
    private String address;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 备注（少于100字）
     */
    private String remark;

    /**
     * 下单商品价格信息
     */
    private String orderPriceSnap;
    /**
     * 支付方式 (1：货到付款， 4：在线支付，5：公司转账， 101：金采支付)
     */
    private Integer paymentType = 4;

    /**
     * 使用余额  paymentType=4时，此值固定是1 其他支付方式 0
     */
    private Integer isUseBalance = 1;

    /**
     * 是否预占库存，0是预占库存（需要调用确认订单接口），1是不预占库存
     */
    private Integer submitState = 1;

    /**
     * 开票方式(2为集中开票，4 订单完成后开票)
     */
    private Integer invoiceState = 2;

    /**
     * 发票类型（2增值税专用发票；3 电子票） 当发票类型为2时，开票方式只支持2集中开票
     */
    private Integer invoiceType = 2;

    /**
     * 发票类型：4：个人，5：单位
     */
    private Integer selectedInvoiceTitle = 5;

    /**
     * 发票抬头  (如果selectedInvoiceTitle=5则此字段必须)
     */
    private String companyName = "北京量化派科技有限公司";

    /**
     * 1:明细，100：大类
     */
    private Integer invoiceContent = 1;

    /**
     * 1价格校验（建议传1）；0 不需要
     */
    private Integer doOrderPriceMode = 1;

    /**
     * 增专票收票人姓名
     */
    private String invoiceName ="张起跃";

    /**
     * 收票人电话
     */
    private String invoicePhone = "15243149899";

    /**
     * 增专票收票人所在省(京东地址编码) 当发票了类型为2增值税专用发票时，该字段必填。
     */
    private Integer invoiceProvice  =1;

    /**
     * 增专票收票人所在市(京东地址编码) 当invoiceType =2时，该字段必填。
     */
    private Integer invoiceCity = 2800;

    /**
     * 增专票收票人所在区/县(京东地址编码) 当invoiceType =2时，该字段必填。
     */
    private Integer invoiceCounty = 2849;

    /**
     * 增专票收票人所在地址当invoiceType =2时，该字段必填。
     */
    private String invoiceAddress = "北京市海淀区中国电子大厦b座17层";

    /**
     * 专票资质公司名称 当invoiceType =2时，该字段必填。
     */
    private String regCompanyName = "北京量化派科技有限公司";

    /**
     * 专票资质纳税人识别号 当invoiceType =2时，该字段必填。
     */
    private String regCode = "91110108MA00D16A0J";

    /**
     * 专票资质注册地址 当invoiceType =2时，该字段必填。
     */
    private String regAddr = "北京市海淀区苏州街49号1层111室";

    /**
     * 专票资质注册电话 当invoiceType =2时，该字段必填。
     */
    private String regPhone	="010-82194732";

    /**
     * 专票资质注册银行 当invoiceType =2时，该字段必填。
     */
    private String regBank = "平安银行北京海淀支行";

    /**
     * 专票资质银行账号 当invoiceType =2时，该字段必填。
     */
    private String regBankAccount = "15000083085234";

    /**
     * 大家电配送日期：默认值为-1，0表示当天，1表示明天，2：表示后天; 如果为-1表示不使用大家电预约日历
     */
    private Integer reservingDate;

    /**
     * 大家电安装日期：默认按-1处理，0表示当天，1表示明天，2：表示后天
     */
    private Integer installDate;

    /**
     * 是否选择了安装，默认为true，选择了“暂缓安装”，此为必填项，必填值为false。
     */
    private boolean needInstall;

    /**
     * 中小件配送预约日期，格式：yyyy-MM-dd
     */
    private String promiseDate;

    /**
     * 中小件配送预约时间段，时间段如： 9:00-15:00
     */
    private String promiseTimeRange;

    /**
     * 中小件预约时间段的标记
     */
    private Integer promiseTimeRangeCode;

    /**
     * 家电配送预约日期，格式：yyyy-MM-dd
     */
    private String reservedDateStr;

    /**
     * 大家电配送预约时间段，如果：9:00-15:00
     */
    private String reservedTimeRange;

    /**
     * 循环日历, 客户传入最近一周可配送的时间段,客户入参:{"3": "09:00-10:00,12:00-19:00","4": "09:00-15:00"}
     */
    private String cycleCalendar;

    /**
     * 采购单号，长度范围[1-26]
     */
    private String poNo;

    /**
     * 节假日不可配送，默认值为false，表示节假日可以配送，为true表示节假日不配送
     */
    private boolean validHolidayVocation;


    @Data
    public static class JdSkuInfo {
        private String skuId;
        private Integer num;
        private boolean bNeedGift = false;
    }

    @Data
    public static class JdSkuPriceInfo{
        private String skuId;
        private BigDecimal price;
    }
}

