package cn.qg.holmes.entity.mock.keystone.jdbuy;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 9.3 查询售后概要
 */
@Data
public class AfsOutlineResponse extends JdBaseResponse{

    private AfsOutlinePage result;

    @Data
    public static class AfsOutlinePage{
        private List<ApplyInfo> data;  //申请单概要信息集合
        private Long pageNum;  //总页数
        private Long total;  //总行数
        private Integer pageNo;  //当前页数
        private Integer pageSize;  //分页行数
    }


    @Data
    public static class ApplyInfo{
        private Long orderId;  //订单号，京东子订单号
        private Long originalOrderId;  //原始单号。售后换新单对应的原始订单编号。
        private String thirdApplyId;  //第三方申请单号。子单下不可重复
        private Boolean isOffline;   //申请途径，1人工发起，2在线发起
        private Integer newPickWareType;   //当前取件方式。即客服审核完成后的货物与返回京东方式。如果该值为空，代表取件方式仍在确认中搜索，请等待第三方申请单状态更新后再次查询。 4上门取件，7客户送货，40客户发货。
        private String pin;  //京东PIN
        private String applyTime;  //申请时间
        private String completeTime;  //完成时间
        private Integer applyStep;  //售后环节。10申请中待审核；20审核完成待收货；30收货完成待处理；40处理完成（如需退款则等待退款）；50待用户确认，60用户确认完成，70取消
        private String customerName;   //客户名称
        private Integer applyNum;   //原始申请数量
        private Integer applicationNum;   //申请中数量
        private Integer wareServiceNum;   //服务中数量
        private Integer confirmNum;   //待确认数量
        private Integer wareCompleteNum;   //完成数量
        private Integer wareCancelNum;   //驳回或取消数量
        private Integer  refundNum;   //退货数量
        private BigDecimal shouldRefundAmount;   //退货商品金额
        private BigDecimal nakedPriceAmount;   //未税价金额
        private BigDecimal realRefundAmount;   //退款金额
        private Integer isComplete;   //是否完成
        private Boolean canCancel;   //是否可以取消
        private Boolean canSendSku;   //是否可以填写发运信息
        private Boolean canConfirm;   //是否可以确认

    }
}
