package cn.qg.holmes.entity.k8s;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * docker项目配置实体类
 * @author libo
 */
@Data
@TableName("docker_project")
public class DockerProject {
    @TableId(type = IdType.AUTO)
    private Integer id;
    private String projectName;
    private String projectType;
    private String gitPath;
    private String gitPathGroup;
    private String hostName;
    private String logPath;
    private String configPath;
    @TableField(value = "`desc`")
    private String desc;
    @TableField(value = "`owner`")
    private String owner;
    private String buildCommand;
    private String startCommand;
    private String stopCommand;
    private Integer deployToDocker;
    private Integer isActive;
    @TableField(value = "`database`")
    private String database;
    private String ddl;
    private String wiki;
    private String api;
    private String memLimit;
    private String memRequest;
    private String cpuLimit;
    private String cpuRequest;
    private Integer sonar;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
