package cn.qg.holmes.controller.k8s;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.service.k8s.DockerProjectService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/docker/project")
public class DockerProjectController {

    @Autowired
    DockerProjectService dockerProjectService;

    /**
     * 获取docker project列表
     * @param pageNum 第几页
     * @param pageSize 每页多少个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getDockerProjectList(@RequestParam(defaultValue = "1") Integer pageNum,
                                           @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<DockerProject> dockerProjectIPage = new Page<>(pageNum, pageSize);
        IPage projectIPage =  dockerProjectService.page(dockerProjectIPage);
        Map<String, Object> map = new HashMap<>();
        map.put("total", projectIPage.getTotal());
        map.put("list", projectIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增docker project
     * @param dockerProject docker项目实体类
     * @return
     */
    @PostMapping("/add")
    public JsonResult addDockerProject(@RequestBody DockerProject dockerProject) {
        return JsonResult.buildSuccessResult(dockerProjectService.save(dockerProject));
    }

    /**
     * 编辑docker project
     * @param dockerProject docker项目实体类
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editDockerProject(@RequestBody DockerProject dockerProject) {
        return JsonResult.buildSuccessResult(dockerProjectService.saveOrUpdate(dockerProject));
    }

    /**
     * 删除docker project
     * @param dockerProjectId 删除id
     * @return
     */
    @GetMapping("/del")
    public JsonResult delDockerProject(@RequestParam Integer dockerProjectId) {
        return JsonResult.buildSuccessResult(dockerProjectService.removeById(dockerProjectId));
    }
}
