package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.effect.DatabaseSyncService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/dbsync")
public class DbSyncController {

    @Autowired
    DatabaseSyncService databaseSyncService;

    @Value("${dbsync.mysql.ip}")
    private String ip;

    @Value("${dbsync.mysql.port}")
    private String port;

    @Value("${dbsync.mysql.username}")
    private String username;

    @Value("${dbsync.mysql.password}")
    private String password;

    @GetMapping("/one")
    public JsonResult syncSingleTable(@RequestParam String namespace, @RequestParam String dbName, @RequestParam String tableName) {
        try {
            Map<String, String> map = databaseSyncService.getMysqlInfoByNamespace(namespace);
            String destIp = map.get("ip");
            String destPort = map.get("port");
            log.info("获取到{}环境的Mysql地址为：{}", namespace, destIp + ":" + destPort);
            if (tableName.equalsIgnoreCase("all")) {
                log.info("开始同步{}库下所有的表", dbName);
                databaseSyncService.getDbInfoFromSource(ip, port, username, password, dbName);
                databaseSyncService.syncDbToDest(destIp, destPort, "qa", "qatest", dbName);
            } else {
                log.info("开始同步{}库下{}表", dbName, tableName);
                databaseSyncService.getSingleTableFromSource(ip, port, username, password, dbName, tableName);
                databaseSyncService.syncSingleTableToDest(destIp, destPort, "qa", "qatest", dbName, tableName);
            }
            return JsonResult.buildSuccessResult("同步成功！");
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("同步失败！", false);
        }
    }

    /**
     * 获取数据库列表
     * @return
     */
    @GetMapping("/dbs")
    public JsonResult getDatabaseList() {
        return JsonResult.buildSuccessResult(databaseSyncService.getDatabaseList(ip, port, username, password));
    }


    /**
     * 获取某个库下的表列表
     * @param dbName 数据库名
     * @return
     */
    @GetMapping("/tables")
    public JsonResult getTableList(@RequestParam String dbName) {
        return JsonResult.buildSuccessResult(databaseSyncService.getTableListByDb(ip, port, username, password, dbName));
    }
}
