package cn.qg.holmes.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import java.sql.*;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * jdbc操作工具类
 * @author libo
 * 2021-12-06
 */
public class JdbcUtils {

    @Autowired
    JdbcTemplate jdbcTemplate;

    public static List<Map<String, Object>> queryForList(String host, String port, String username, String password, String db, String sql) {
        String driver = "com.mysql.jdbc.Driver";
        String url;
        if (db == null) {
            url = "jdbc:mysql://" + host + ":" + port;
        } else {
            url = "jdbc:mysql://" + host + ":" + port + "/" + db;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;

        try {
            Class.forName(driver);
            connection = DriverManager.getConnection(url, username, password);

            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            List<Map<String, Object>> resultList = convertResultSetToList(resultSet);
            return resultList;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                resultSet.close();
                statement.close();
                connection.close();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (resultSet != null) {
                    resultSet = null;
                }
                if (statement != null) {
                    statement = null;
                }
                if (connection != null) {
                    connection = null;
                }
            }
        }
    }

    /**
     * ResultSet转列表
     * @param resultSet
     * @return
     */
    public static List<Map<String, Object>> convertResultSetToList(ResultSet resultSet) {
        if (null == resultSet) {
            return null;
        }
        List<Map<String, Object>> dataList = new ArrayList<>();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                Map<String, Object> rowData = new LinkedHashMap<>();
                for (int i = 0, columnCount = resultSetMetaData.getColumnCount(); i < columnCount; i++) {
                    rowData.put(resultSetMetaData.getColumnName(i + 1), resultSet.getObject(i + 1));
                }
                dataList.add(rowData);
            }
        } catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return dataList;
    }
}
