package cn.qg.holmes.aspect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.exception.TokenInvalidException;
import cn.qg.holmes.exception.UnauthorizedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class ExceptionHandlerAdvice {

    @ExceptionHandler(UnauthorizedException.class)
    public JsonResult handleException(UnauthorizedException e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult("权限不足！", false);
    }

    @ExceptionHandler(TokenInvalidException.class)
    public JsonResult handleException(TokenInvalidException e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult("登录已失效，请重新登录！", false);
    }

    @ExceptionHandler(Exception.class)
    public JsonResult handleException(Exception e) {
        e.printStackTrace();
        return JsonResult.buildErrorStateResult("系统异常！", false);
    }
}
