package cn.qg.holmes.interceptor;

import cn.qg.holmes.entity.mock.Mock;
import cn.qg.holmes.mapper.mock.MockMapper;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

/**
 * 风控相关接口拦截器
 * @author libo
 */
@Slf4j
public class RuleEngineInterceptor implements HandlerInterceptor {

    @Autowired
    MockMapper mockMapper;

    public Map<String, Object> convertParameterMap(Map<String, String[]> parameterMap) {
        Map<String, Object> map = new HashMap<>();
        for (Map.Entry<String, String[]> entry: parameterMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue()[0];
            map.put(key, value);
        }
        return map;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String uri = request.getRequestURI();
        Map<String, String[]> parameterMap = request.getParameterMap();
        Map<String, Object> requestMap = convertParameterMap(parameterMap);
        QueryWrapper<Mock> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("url", uri);
        Mock mock = mockMapper.selectOne(queryWrapper);
        if (uri.equals("/rule_engine/middle_office/audit")) {
            Map<String, Object> responseMap = handleRiskAudit(requestMap);
            InterceptorUtils.constructResponse(response, JSON.toJSONString(responseMap), "application/json; charset=utf-8");
            return false;
        }
        if (mock.getFlag() == 0) {
            InterceptorUtils.constructResponse(response, mock.getFail(), "application/json; charset=utf-8");
        } else if (mock.getFlag() == 1) {
            InterceptorUtils.constructResponse(response, mock.getSuccess(), "application/json; charset=utf-8");
        }
        return true;
    }

    public Map<String, Object> handleRiskAudit(Map<String, Object> requestMap) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) + 15);
        Long openingDeadLine = calendar.getTimeInMillis();
        Map<String, Object> bodyMap = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("code", 0);
        resultMap.put("msg", "success");
        bodyMap.put("msg", "success");
        bodyMap.put("fundRate", null);
        bodyMap.put("secondaryValidation", "-1");
        bodyMap.put("amountRate", null);
        bodyMap.put("isWhiteBlackListHit", null);
        bodyMap.put("openingValidity", "15");
        bodyMap.put("creditLevel", null);
        bodyMap.put("isFuseModuleHit", null);
        bodyMap.put("callbackUrl", null);
        bodyMap.put("amountTermLimits", null);
        bodyMap.put("bizType", requestMap.get("bizType"));
        bodyMap.put("bizChannel", requestMap.get("bizChannel"));
        bodyMap.put("uuid", requestMap.get("uuid"));
        bodyMap.put("bizNo", requestMap.get("bizNo"));
        bodyMap.put("sceneId", requestMap.get("sceneId"));
        bodyMap.put("auditResult", true);
        bodyMap.put("amount", null);
        bodyMap.put("term", null);
        bodyMap.put("validity", "30");
        bodyMap.put("deadLine", "4102415999000");
        bodyMap.put("financeProducts", null);
        bodyMap.put("otherInformation", null);
        bodyMap.put("quotaPaymentAmount", null);
        bodyMap.put("extData", null);
        bodyMap.put("success", true);
        bodyMap.put("refuseReason", null);
        bodyMap.put("allowInstalment", null);
        bodyMap.put("allowInstalmentTerms", null);
        bodyMap.put("openingDeadLine", null);
        if (requestMap.get("bizType").equals("8") && requestMap.get("sceneId").equals("12")) {
            bodyMap.put("quotaPaymentAmount", "10000");
        }
        resultMap.put("body", bodyMap);
        return resultMap;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           @Nullable ModelAndView modelAndView) throws Exception {
        log.info("本次请求返回响应：{}", response);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                @Nullable Exception ex) throws Exception {
    }

}
