package cn.qg.holmes.quartz;

import cn.qg.holmes.entity.monitor.MonitorDataSource;
import cn.qg.holmes.entity.monitor.MonitorTask;
import cn.qg.holmes.service.monitor.MonitorDataSourceService;
import cn.qg.holmes.service.monitor.MonitorTaskService;
import cn.qg.holmes.utils.DingdingUtils;
import cn.qg.holmes.utils.JdbcUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Slf4j
public class DbQueryTask extends QuartzJobBean {

    @Autowired
    MonitorDataSourceService monitorDataSourceService;

    @Autowired
    MonitorTaskService monitorTaskService;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        // 定时任务名称
        String taskName = jobDetail.getKey().getName();
        // 获取定时任务信息
        QueryWrapper<MonitorTask> monitorTaskQueryWrapper = new QueryWrapper<>();
        monitorTaskQueryWrapper.eq("task_name", taskName);
        MonitorTask monitorTask = monitorTaskService.getOne(monitorTaskQueryWrapper);
        // 获取数据源相关信息
        Integer dsId = monitorTask.getDsId();
        MonitorDataSource monitorDataSource = monitorDataSourceService.getById(dsId);

        List<Map<String, Object>> resultList = JdbcUtils.queryForList(monitorDataSource.getHost(), monitorDataSource.getPort(),
                monitorDataSource.getUsername(), monitorDataSource.getPassword(), null, monitorTask.getSql());
        String dingUrl = monitorTask.getDingUrl();
        String dingText = monitorTask.getDingText();
//        dingText = dingText.replaceAll("\\{count}", String.valueOf(resultList.size()));
        dingText = replaceDingText(dingText, resultList);
        String markdownMsg = DingdingUtils.buildMarkdownMsg("监控测试", dingText + "\n" + JSON.toJSONString(resultList), false);
        DingdingUtils.sendToDingding(markdownMsg, dingUrl);
    }

    public static String replaceDingText(String dingText, List<Map<String, Object>> queryList) {
        if (dingText.contains("{count}")) {
            dingText = dingText.replace("{count}", String.valueOf(queryList.size()));
        }
        Pattern numPattern = Pattern.compile(".*\\(\\{\\d+}\\).*");
        Matcher matcher = numPattern.matcher(dingText);
        List<String> firstLineDataList = null;
        if (queryList.size() > 0) {
            firstLineDataList = new ArrayList(queryList.get(0).values());
        }

        if (matcher.find()) {
            int count = matcher.groupCount();
            System.out.println(count);
            System.out.println(matcher.group(0));
            for (int i=0; i < count; i++) {
                dingText.replace(matcher.group(i+1), firstLineDataList.get(i));
            }
        }
        return dingText;
    }

    public static void main(String[] args) {
        String dingText = "监控定时任务测试，本次共查出{count}条数据，第一行第一列数据是{0}啦啦啦, {1}";
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> map1 = new LinkedHashMap<>();
        Map<String, Object> map2 = new LinkedHashMap<>();
        map1.put("sku_no", "123");
        map1.put("sku_name", "商品一");
        map2.put("sku_no", "456");
        map2.put("sku_name", "商品二");
        mapList.add(map1);
        mapList.add(map2);
        dingText = replaceDingText(dingText, mapList);
        System.out.println(dingText);
    }

}
