package cn.qg.holmes.service.quality.impl;

import cn.qg.holmes.service.quality.JiraService;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import io.atlassian.util.concurrent.Promise;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.springframework.stereotype.Service;

import java.net.URI;
import java.net.URISyntaxException;

@Service
public class JiraServiceImpl implements JiraService {

    public static String url = "http://jira2.quantgroup.cn/";
    public static String username = "test1";
    public static String password = "123456";
    public static JiraRestClient jiraRestClient = createJiraRestClient();

    public static JiraRestClient createJiraRestClient() {
        JiraRestClientFactory jiraRestClientFactory = new AsynchronousJiraRestClientFactory();
        JiraRestClient jiraRestClient = null;
        try {
            jiraRestClient = jiraRestClientFactory.createWithBasicHttpAuthentication(new URI(url), username, password);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jiraRestClient;
    }

    /**
     * 根据项目关键字获取未解决BUG列表
     *
     * @param project 项目关键字，如"YXM"
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<Issue> getUnsolvedIssueListByProject(String project) throws Exception {
        Promise<SearchResult> resultPromise = jiraRestClient.getSearchClient().searchJql("project = " + project + " AND resolution = Unresolved ORDER BY priority DESC");
        Iterable<Issue> issues = resultPromise.get().getIssues();
        return issues;
    }

    /**
     * 根据JQL获取BUG列表
     *
     * @param JQL jira JQL
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<Issue> getIssueListByJQL(String JQL) throws Exception {
        Promise<SearchResult> resultPromise = jiraRestClient.getSearchClient().searchJql(JQL);
        Iterable<Issue> issues = resultPromise.get().getIssues();
        return issues;
    }

    /**
     * 获取Jira项目列表
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<BasicProject> getJiraProjectList() throws Exception {
        Promise<Iterable<BasicProject>> allProjects = jiraRestClient.getProjectClient().getAllProjects();
        Iterable<BasicProject> basicProjects = allProjects.get();
        return basicProjects;
    }

    @Override
    public Issue getJiraIssueByKey(String key) {
        try {
            Issue issue = jiraRestClient.getIssueClient().getIssue(key).get();
            return issue;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 计算BUG修复时间
     * @param startDate BUG创建时间
     * @param endDate   BUG最近一次更新时间
     * @return
     */
    @Override
    public Integer calculateBugFixTime(DateTime startDate, DateTime endDate) {
        int startHour = startDate.getHourOfDay();
        int endHour = endDate.getHourOfDay();
        int startMinute = startDate.getMinuteOfHour();
        int endMinute = endDate.getMinuteOfHour();
        int startSecond = startDate.getSecondOfMinute();
        int endSecond = endDate.getSecondOfMinute();
        boolean daySubFlag = true;
        if (endHour < startHour) {
            daySubFlag = false;
        }
        if (endHour == startHour && endMinute < startMinute) {
            daySubFlag = false;
        }
        if (endHour == startHour && endMinute == startMinute && endSecond < startSecond) {
            daySubFlag = false;
        }

        if (startHour >= 19) {
            startHour = 19;
        }
        if (startHour <= 10) {
            startHour = 10;
        }
        if (endHour >= 19) {
            endHour = 19;
        } 
        if (endHour <= 10) {
            endHour = 10;
        }
        int hourDiff = endHour - startHour;
        int days = Days.daysBetween(startDate, endDate).getDays();
        return daySubFlag ? days * 8 + hourDiff : (days + 1) * 8 + hourDiff;
    }

}
