package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.RolePermission;
import cn.qg.holmes.entity.auth.RolePermissionVo;
import cn.qg.holmes.service.auth.RolePermissionService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@CrossOrigin
@RestController
@RequestMapping("/role/permission")
public class RolePermissionController {

    @Autowired
    RolePermissionService rolePermissionService;

    /**
     * 新增角色权限
     * @param roleId 角色id
     * @param permissionIdList 权限id列表
     * @return
     */
    @PostMapping("/add")
    public JsonResult addRolePermission(Integer roleId, List<Integer> permissionIdList) {
        List<RolePermission> rolePermissionList = new ArrayList<>();
        permissionIdList.forEach(permissionId -> {
            RolePermission rolePermission = new RolePermission();
            rolePermission.setRoleId(roleId);
            rolePermission.setPermissionId(permissionId);
            rolePermissionList.add(rolePermission);
        });
        return JsonResult.buildSuccessResult(rolePermissionService.saveBatch(rolePermissionList));
    }

    /**
     * 编辑角色权限
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editRolePermission(RolePermissionVo rolePermissionVo) {
        Integer roleId = rolePermissionVo.getRoleId();
        List<RolePermission> rolePermissionList = rolePermissionVo.getRolePermissionList();
        QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
        rolePermissionQueryWrapper.eq("role_id", roleId);
        List<RolePermission> rolePermissionListDb = rolePermissionService.list(rolePermissionQueryWrapper);
        for (RolePermission rolePermissionDb: rolePermissionListDb) {
            boolean flag = false;
            for (RolePermission rolePermission: rolePermissionList) {
                if (rolePermission.getId().equals(rolePermissionDb.getPermissionId())) {
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                rolePermissionService.removeById(rolePermissionDb.getId());
            }
        }
        return JsonResult.buildSuccessResult(rolePermissionService.saveOrUpdateBatch(rolePermissionList));
    }

    /**
     * 删除角色权限
     * @param rolePermissionId 角色权限
     * @return
     */
    @GetMapping("/del")
    public JsonResult delRolePermission(Integer rolePermissionId) {
        return JsonResult.buildSuccessResult(rolePermissionService.removeById(rolePermissionId));
    }
}
