package cn.qg.holmes.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;

/**
 * 数据源设置
 * @author libo 2021-03-20
 */
@Configuration
public class DataSourceConfiguration {

    @Value("${holmes.data.mysql.jdbc-url}")
    private String holmesJdbcUrl;

    @Value("${holmes.data.mysql.user}")
    private String user;

    @Value("${holmes.data.mysql.password}")
    private String password;

    @Value("${holmes.data.mysql.max-pool-size}")
    private Integer maxPoolSize;

    @Bean
    public DataSource dataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(holmesJdbcUrl);
        config.setUsername(user);
        config.setPassword(password);
//        config.addDataSourceProperty("cachePrepStmts", "true");
//        config.addDataSourceProperty("prepStmtCacheSize", "250");
//        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }
}
