package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.Role;
import cn.qg.holmes.service.auth.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@CrossOrigin
@RestController
@RequestMapping("/role")
public class RoleController {

    @Autowired
    RoleService roleService;

    /**
     * 新增角色
     * @param role 角色实体
     * @return
     */
    @PostMapping("/add")
    public JsonResult addRole(@RequestBody Role role) {
        return JsonResult.buildSuccessResult(roleService.save(role));
    }

    /**
     * 编辑角色
     * @param role 角色实体
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editRole(@RequestBody Role role) {
        return JsonResult.buildSuccessResult(roleService.saveOrUpdate(role));
    }

    /**
     * 删除角色
     * @param roleId 角色id
     * @return
     */
    @PostMapping("/delete")
    public JsonResult delRole(Integer roleId) {
        return JsonResult.buildSuccessResult(roleService.removeById(roleId));
    }
}
