package cn.qg.holmes.interceptor;

import cn.qg.holmes.encrypt.LanzhouBankEncrypt;
import cn.qg.holmes.entity.lanzhou.BaseReq;
import cn.qg.holmes.entity.lanzhou.BaseResp;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * 兰银mock拦截器
 */
@Slf4j
public class LanzhouBankInterceptor implements HandlerInterceptor {

    @Value("${lanzhou.fund.public.key}")
    private String lanzhouPublicKey;

    @Value("${lanzhou.lhp.private.key}")
    private String lhpPrivateKey;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception{
        String uri = request.getRequestURI();
        log.info("收到兰银{}接口请求：", uri);
        Map<String, String[]> parameterMap = request.getParameterMap();
        Map<String, Object> requestJson = InterceptorUtils.convertParameterMap(parameterMap);
        String requestMessage = LanzhouBankEncrypt.decrypt(requestJson.get("message").toString(), requestJson.get("signature").toString(), lhpPrivateKey);
        Map<String, Object> responseMap = new HashMap<>();
        if (StringUtils.isNotBlank(requestMessage)) {
            BaseReq<Map<String, String>> req = JSON.parseObject(requestMessage, BaseReq.class);
            if (req.getTranscode().equals("channel.common.queryapplyresult")) {
                // 资方预审结果查询
                Map<String, String> params = req.getT();
                responseMap.put("channelserialno", params.get("channelserialno"));
                responseMap.put("producttype", params.get("producttype"));
                responseMap.put("submitflag", "10"); //  10-授信成功，04-授信失败，03-处理中

            } else if (req.getTranscode().equals("channel.common.querybusinessrate")) {
                // 利率查询接口
                responseMap.put("businessrate", 0.36);
            }
            BaseResp<Map<String, Object>> resp = new BaseResp();
            resp.setResult(responseMap);
            resp.setIssuccess(true);
            resp.setRtncode("0000");
            resp.setRtnmessage("请求成功");
            String[] messageArray = LanzhouBankEncrypt.encrypt(JSON.toJSONString(resp).getBytes(), lanzhouPublicKey);
            Map<String, String> respStr = new HashMap<>();
            respStr.put("message", messageArray[0]);
            respStr.put("signature", messageArray[1]);
            InterceptorUtils.constructResponse(response, JSON.toJSONString(respStr), "application/json; charset=utf-8");
            return false;
        } else {
            log.info("接口{} 的mock暂不支持！", uri);
            Map<String, String> respStr = new HashMap<>();
            respStr.put("message", "Mock暂不支持！");
            InterceptorUtils.constructResponse(response, JSON.toJSONString(respStr), "application/json; charset=utf-8");
            return false;
        }
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           @Nullable ModelAndView modelAndView) {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler,
                                @Nullable Exception ex) {
    }
}
