package cn.qg.holmes.service.k8s;

import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class MqService {

    /**
     * 获取MQ信息
     *
     * @param host
     * @param auth
     * @return
     */
    public Map<String, Object> getDefinitionsOfHost(String host, String auth) {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        String response = HttpClientUtils.doGet(host + "/api/definitions", headers, null);
        return JSON.parseObject(response, Map.class);
    }

    /**
     * 同步线上MQ到测试
     *
     * @param host
     * @return
     */
    public boolean setDefinitions(String host) {
        try {
            String ONLINE_MQ_URL = "http://172.30.3.140:15672";
            String ONLINE_MQ_AUTH = "Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=";
            Map<String, Object> onlineDefinitions = getDefinitionsOfHost(ONLINE_MQ_URL, ONLINE_MQ_AUTH);
            List<Map<String, String>> permissionList = (List<Map<String, String>>) onlineDefinitions.get("permissions");
            List<Map<String, String>> qaPermissionList = new ArrayList<>();
            for (Map<String, String> permission : permissionList) {
                if (permission.get("user").equals("rabbit_admin")) {
                    Map<String, String> temp = new HashMap<>();
                    temp.putAll(permission);
                    qaPermissionList.add(temp);
                    permission.put("user", "qa");
                    qaPermissionList.add(permission);
                } else if (!permission.get("user").equals("qa") && !permission.get("user").equals("rabbit_admin")) {
                    qaPermissionList.add(permission);
                }
            }
            onlineDefinitions.put("permissions", qaPermissionList);
            String QA_MQ_AUTH = "Basic cWE6cWF0ZXN0";
            String qaMqUrl = "http://" + host + "/api/definitions";
            Map<String, String> headers = new HashMap<>();
            headers.put("Authorization", QA_MQ_AUTH);
            headers.put("Content-Type", "application/json");
            HttpClientUtils.doPostJson(qaMqUrl, headers, JSON.toJSONString(onlineDefinitions));
            log.info("MQ同步成功：{}", host);
            return true;
        } catch (Exception e) {
            log.info("MQ同步失败：{}", host);
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDefinitions(String sourceHost, String targetHost) {
        try {
            String ONLINE_MQ_URL = "http://" + sourceHost;
            String ONLINE_MQ_AUTH = "Basic cWE6cWF0ZXN0";
            Map<String, Object> onlineDefinitions = getDefinitionsOfHost(ONLINE_MQ_URL, ONLINE_MQ_AUTH);
            List<Map<String, String>> permissionList = (List<Map<String, String>>) onlineDefinitions.get("permissions");
            List<Map<String, String>> qaPermissionList = new ArrayList<>();
            for (Map<String, String> permission : permissionList) {
                if (permission.get("user").equals("rabbit_admin")) {
                    Map<String, String> temp = new HashMap<>();
                    temp.putAll(permission);
                    qaPermissionList.add(temp);
                    permission.put("user", "qa");
                    qaPermissionList.add(permission);
                } else if (!permission.get("user").equals("qa") && !permission.get("user").equals("rabbit_admin")) {
                    qaPermissionList.add(permission);
                }
            }
            onlineDefinitions.put("permissions", qaPermissionList);
            String QA_MQ_AUTH = "Basic cWE6cWF0ZXN0";
            String qaMqUrl = "http://" + targetHost + "/api/definitions";
            Map<String, String> headers = new HashMap<>();
            headers.put("Authorization", QA_MQ_AUTH);
            headers.put("Content-Type", "application/json");
            HttpClientUtils.doPostJson(qaMqUrl, headers, JSON.toJSONString(onlineDefinitions));
            log.info("MQ同步成功：{}", targetHost);
            return true;
        } catch (Exception e) {
            log.info("MQ同步失败：{}", targetHost);
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 获取 sourceMapList 比 targetMapList 多出的元素
     *
     * @param sourceMapList
     * @param targetMapList
     * @return
     */
    public List<String> mqListCompare(List<Map<String, String>> sourceMapList, List<Map<String, String>> targetMapList) {
        List<String> resultList = new ArrayList<>();
        for (Map<String, String> sourceMap : sourceMapList) {
            boolean flag = false;
            for (Map<String, String> targetMap : targetMapList) {
                if (sourceMap.get("name").equals(targetMap.get("name"))) {
                    flag = true;
                }
            }
            if (!flag) {
                resultList.add(sourceMap.get("name"));
            }
        }
        return resultList;
    }

    /**
     * 比较测试环境与线上mq
     * @param host 测试环境mq地址：ip+端口
     * @return
     */
    public Map<String, Object> getMqDiff(String host) {
        String ONLINE_MQ_URL = "http://172.30.3.140:15672";
        String ONLINE_MQ_AUTH = "Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=";
        Map<String, Object> onlineDefinitions = getDefinitionsOfHost(ONLINE_MQ_URL, ONLINE_MQ_AUTH);
        String qaMqUrl = "http://" + host;
        String QA_MQ_AUTH = "Basic cWE6cWF0ZXN0";
        Map<String, Object> qaDefinitions = getDefinitionsOfHost(qaMqUrl, QA_MQ_AUTH);
        List<Map<String, String>> onlineHostList = (List<Map<String, String>>) onlineDefinitions.get("vhosts");
        List<Map<String, String>> qaHostList = (List<Map<String, String>>) qaDefinitions.get("vhosts");
        List<Map<String, String>> onlineQueueList = (List<Map<String, String>>) onlineDefinitions.get("queues");
        List<Map<String, String>> qaQueueList = (List<Map<String, String>>) qaDefinitions.get("queues");
        List<String> lostVhostList = mqListCompare(onlineHostList, qaHostList);
        List<String> moreVhostList = mqListCompare(qaHostList, onlineHostList);
        List<String> lostQueueList = mqListCompare(onlineQueueList, qaQueueList);
        List<String> moreQueueList = mqListCompare(qaQueueList, onlineQueueList);
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> lostMap = new HashMap<>();
        lostMap.put("vhost", lostVhostList);
        lostMap.put("queue", lostQueueList);
        Map<String, Object> moreMap = new HashMap<>();
        moreMap.put("vhost", moreVhostList);
        moreMap.put("queue", moreQueueList);
        if (lostVhostList.size() > 0 || lostQueueList.size() > 0) {
            lostMap.put("show", true);
        } else {
            lostMap.put("show", false);
        }
        if (moreVhostList.size() > 0 || moreQueueList.size() > 0) {
            moreMap.put("show", true);
        } else {
            moreMap.put("show", false);
        }
        map.put("lost", lostMap);
        map.put("more", moreMap);
        return map;
    }

    public static void main(String[] args) {
        MqService mqService = new MqService();
        mqService.setDefinitions("172.17.5.46:32419");
    }
}
