package cn.qg.holmes.controller.monitor;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.monitor.SqlMonitorTask;
import cn.qg.holmes.service.monitor.SqlMonitorTaskService;
import com.alibaba.fastjson.JSON;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Quartz相关接口
 */
@RestController
@RequestMapping("/quartz")
public class QuartzController {

    @Autowired
    Scheduler scheduler;

    @Autowired
    SqlMonitorTaskService sqlMonitorTaskService;

    @GetMapping("/job/list")
    public JsonResult getQuartzList() throws SchedulerException {
        List<Map<String, String>> jobDetailList = new ArrayList<>();
        List<SqlMonitorTask> sqlMonitorTaskList = sqlMonitorTaskService.list();
        for (SqlMonitorTask sqlMonitorTask: sqlMonitorTaskList) {
            JobKey jobKey = JobKey.jobKey(sqlMonitorTask.getTaskName());
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            if (jobDetail != null) {
                jobDetailList.add(JSON.parseObject(JSON.toJSONString(jobDetail), Map.class));
            }
        }
        return JsonResult.buildSuccessResult(jobDetailList);
    }
}
