package cn.qg.holmes.utils;

import com.mongodb.*;
import com.mongodb.client.MongoDatabase;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Slf4j
public class MongoUtils {

    public static String createDbWithAuthentication(String host, int port, String dbName, String username, String password) {
        MongoClient mongoClient = null;
        Document document = null;
        try {
            ServerAddress serverAddress = new ServerAddress(host,port);
            MongoCredential mongoCredential = MongoCredential.createScramSha1Credential("qa", "admin", "qatest".toCharArray());
            MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
            mongoClient = new MongoClient(serverAddress, mongoCredential, builder.build());
            MongoDatabase mongoDatabase = mongoClient.getDatabase(dbName);

            BasicDBObject basicDBObject = new BasicDBObject("createUser", username).append("pwd", password).append("roles",
                    Collections.singletonList(new BasicDBObject("role", "dbOwner").append("db", dbName)));
            document = mongoDatabase.runCommand(basicDBObject);
            log.info("创建mongodb用户，执行{}命令, 返回结果：{}", basicDBObject.toJson(), document);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (mongoClient != null) {
                mongoClient.close();
            }
        }
        if (document != null) {
            return document.toJson();
        }
        return null;
    }

    public static void main(String[] args) {
        String host = "172.17.5.42";
        int port = 32683;
        String dbName = "ocrDb";
        String username = "qa";
        String password = "qatest";
//        String result = createDbWithAuthentication(host, port, dbName, username, password);
//        System.out.println(result);

        List<String> dbList = new ArrayList<>();
        dbList.add("ocrDb");
        dbList.add("test4");
        for (String db: dbList) {
            createDbWithAuthentication(host, port, db, "qa", "qatest");
        }
    }
}
